/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.config;

import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigSyncHandler;
import com.gtnewhorizon.gtnhlib.config.SyncedConfigElement;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;

public class PacketSyncConfig
implements IMessage {
    public final Object2ObjectMap<String, String> syncedElements = new Object2ObjectOpenHashMap<String, String>();

    public PacketSyncConfig() {
    }

    PacketSyncConfig(Collection<SyncedConfigElement> elements) {
        for (SyncedConfigElement element : elements) {
            try {
                this.syncedElements.put(element.toString(), element.getValue());
            }
            catch (ConfigException e) {
                GTNHLib.LOG.error("Failed to serialize config element: {}", new Object[]{element.toString(), e});
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.syncedElements.put(ByteBufUtils.readUTF8String((ByteBuf)buf), ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.syncedElements.size());
        for (Object2ObjectMap.Entry entry : this.syncedElements.object2ObjectEntrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)entry.getKey()));
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)entry.getValue()));
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSyncConfig, IMessage> {
        public IMessage onMessage(PacketSyncConfig message, MessageContext ctx) {
            ConfigSyncHandler.onSync(message);
            return null;
        }
    }
}

