/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util.data;

import com.gtnewhorizon.gtnhlib.hash.Fnv1a32;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.util.ItemUtil;
import com.gtnewhorizon.gtnhlib.util.data.ImmutableItemMeta;
import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public final class ItemId
implements ImmutableItemStack {
    private final Item item;
    private final int meta;
    private final NBTTagCompound tag;
    public static final Hash.Strategy<ItemId> ITEM_META_STRATEGY = new Hash.Strategy<ItemId>(){

        @Override
        public int hashCode(ItemId o) {
            int hash = Fnv1a32.initialState();
            if (o != null) {
                hash = Fnv1a32.hashStep(hash, Objects.hashCode(o.item));
                hash = Fnv1a32.hashStep(hash, o.meta);
            }
            return hash;
        }

        @Override
        public boolean equals(ItemId a, ItemId b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.getItem() == b.getItem() && a.meta == b.meta;
        }
    };
    public static final Hash.Strategy<ItemId> ITEM_META_NBT_STRATEGY = new Hash.Strategy<ItemId>(){

        @Override
        public int hashCode(ItemId o) {
            int hash = Fnv1a32.initialState();
            if (o != null) {
                hash = Fnv1a32.hashStep(hash, Objects.hashCode(o.item));
                hash = Fnv1a32.hashStep(hash, o.meta);
                hash = Fnv1a32.hashStep(hash, Objects.hashCode(o.tag));
            }
            return hash;
        }

        @Override
        public boolean equals(ItemId a, ItemId b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.item == b.item && a.meta == b.meta && Objects.equals(a.tag, b.tag);
        }
    };
    public static final Hash.Strategy<ItemStack> STACK_ITEM_META_STRATEGY = new Hash.Strategy<ItemStack>(){

        @Override
        public int hashCode(ItemStack o) {
            int hash = Fnv1a32.initialState();
            if (o != null) {
                hash = Fnv1a32.hashStep(hash, Objects.hashCode(o.func_77973_b()));
                hash = Fnv1a32.hashStep(hash, ItemUtil.getStackMeta(o));
            }
            return hash;
        }

        @Override
        public boolean equals(ItemStack a, ItemStack b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.func_77973_b() != b.func_77973_b()) {
                return false;
            }
            return ItemUtil.getStackMeta(a) == ItemUtil.getStackMeta(b);
        }
    };
    public static final Hash.Strategy<ItemStack> STACK_ITEM_META_NBT_STRATEGY = new Hash.Strategy<ItemStack>(){

        @Override
        public int hashCode(ItemStack o) {
            int hash = Fnv1a32.initialState();
            if (o != null) {
                hash = Fnv1a32.hashStep(hash, Objects.hashCode(o.func_77973_b()));
                hash = Fnv1a32.hashStep(hash, ItemUtil.getStackMeta(o));
                hash = Fnv1a32.hashStep(hash, Objects.hashCode(o.func_77978_p()));
            }
            return hash;
        }

        @Override
        public boolean equals(ItemStack a, ItemStack b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.func_77973_b() != b.func_77973_b()) {
                return false;
            }
            if (ItemUtil.getStackMeta(a) != ItemUtil.getStackMeta(b)) {
                return false;
            }
            return Objects.equals(a.func_77978_p(), b.func_77978_p());
        }
    };
    public static final Hash.Strategy<Object> GENERIC_ITEM_META_STRATEGY = new Hash.Strategy<Object>(){

        @Override
        public int hashCode(Object o) {
            int hash = Fnv1a32.initialState();
            if (o != null) {
                hash = Fnv1a32.hashStep(hash, Objects.hashCode(ItemId.getGenericItem(o)));
                hash = Fnv1a32.hashStep(hash, ItemId.getGenericMeta(o));
            }
            return hash;
        }

        @Override
        public boolean equals(Object a, Object b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (ItemId.getGenericItem(a) != ItemId.getGenericItem(b)) {
                return false;
            }
            return ItemId.getGenericMeta(a) == ItemId.getGenericMeta(b);
        }
    };
    public static final Hash.Strategy<Object> GENERIC_ITEM_META_NBT_STRATEGY = new Hash.Strategy<Object>(){

        @Override
        public int hashCode(Object o) {
            int hash = Fnv1a32.initialState();
            if (o != null) {
                hash = Fnv1a32.hashStep(hash, Objects.hashCode(ItemId.getGenericItem(o)));
                hash = Fnv1a32.hashStep(hash, ItemId.getGenericMeta(o));
                hash = Fnv1a32.hashStep(hash, Objects.hashCode(ItemId.getGenericTag(o)));
            }
            return hash;
        }

        @Override
        public boolean equals(Object a, Object b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (ItemId.getGenericItem(a) != ItemId.getGenericItem(b)) {
                return false;
            }
            if (ItemId.getGenericMeta(a) == ItemId.getGenericMeta(b)) {
                return false;
            }
            return Objects.equals(ItemId.getGenericTag(a), ItemId.getGenericTag(b));
        }
    };

    public ItemId(Item item, int meta, NBTTagCompound tag) {
        this.item = item;
        this.meta = meta;
        this.tag = tag;
    }

    @Override
    @NotNull
    public Item getItem() {
        return this.item;
    }

    @Override
    public int getItemMeta() {
        return this.meta;
    }

    @Override
    public NBTTagCompound getTag() {
        return this.tag;
    }

    @Override
    public int getStackSize() {
        return 0;
    }

    public static ItemId create(NBTTagCompound tag) {
        return new ItemId(Item.func_150899_d((int)tag.func_74762_e("id")), tag.func_74762_e("Damage"), tag.func_150297_b("tag", 10) ? tag.func_74775_l("tag") : null);
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        tag.func_74768_a("id", Item.func_150891_b((Item)this.item));
        tag.func_74768_a("Damage", this.meta);
        if (this.tag != null) {
            tag.func_74782_a("tag", tag.func_74737_b());
        }
        return tag;
    }

    public static ItemId create(ItemStack stack) {
        return ItemId.create(stack.func_77973_b(), ItemUtil.getStackMeta(stack), stack.func_77978_p());
    }

    public static ItemId create(Item item, int metaData, @Nullable NBTTagCompound tag) {
        if (tag != null) {
            tag = (NBTTagCompound)tag.func_74737_b();
        }
        return new ItemId(item, metaData, tag);
    }

    public static ItemId createAsWildcard(ItemStack stack) {
        return new ItemId(stack.func_77973_b(), Short.MAX_VALUE, stack.func_77978_p());
    }

    public static ItemId createAsWildcardWithoutNBT(ItemStack stack) {
        return ItemId.create(stack.func_77973_b(), Short.MAX_VALUE, null);
    }

    public static ItemId createWithoutNBT(ItemStack stack) {
        return new ItemId(stack.func_77973_b(), ItemUtil.getStackMeta(stack), null);
    }

    public static ItemId createNoCopy(Item item, int metaData, @Nullable NBTTagCompound nbt) {
        return new ItemId(item, metaData, nbt);
    }

    public static ItemId createNoCopy(ItemStack stack) {
        return new ItemId(stack.func_77973_b(), ItemUtil.getStackMeta(stack), stack.func_77978_p());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ItemId)) {
            return false;
        }
        ItemId itemId = (ItemId)o;
        return ITEM_META_NBT_STRATEGY.equals(this, itemId);
    }

    public int hashCode() {
        return ITEM_META_NBT_STRATEGY.hashCode(this);
    }

    public String toString() {
        return "ItemId[item=" + this.item + ", meta=" + this.meta + ", tag=" + this.tag + ']';
    }

    private static Item getGenericItem(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Item) {
            Item item = (Item)obj;
            return item;
        }
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            return stack.func_77973_b();
        }
        if (obj instanceof ImmutableItemMeta) {
            ImmutableItemMeta im = (ImmutableItemMeta)obj;
            return im.getItem();
        }
        throw new IllegalArgumentException("Cannot extract item from object: " + obj);
    }

    private static int getGenericMeta(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            return ItemUtil.getStackMeta(stack);
        }
        if (obj instanceof ImmutableItemMeta) {
            ImmutableItemMeta im = (ImmutableItemMeta)obj;
            return im.getItemMeta();
        }
        throw new IllegalArgumentException("Cannot extract item metadata from object: " + obj);
    }

    private static NBTTagCompound getGenericTag(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            return stack.func_77978_p();
        }
        if (obj instanceof ImmutableItemStack) {
            ImmutableItemStack stack = (ImmutableItemStack)obj;
            return stack.getTag();
        }
        throw new IllegalArgumentException("Cannot extract item metadata from object: " + obj);
    }
}

