/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.vbo;

import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class VertexBuffer
implements AutoCloseable {
    protected int id;
    protected int vertexCount;
    protected final VertexFormat format;
    protected final int drawMode;

    public VertexBuffer(VertexFormat format, int drawMode) {
        if (format == null) {
            throw new IllegalStateException("No format specified for VBO");
        }
        this.id = GL15.glGenBuffers();
        this.format = format;
        this.drawMode = drawMode;
    }

    public void bind() {
        GL15.glBindBuffer((int)34962, (int)this.id);
    }

    public void unbind() {
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public void upload(ByteBuffer buffer, int vertexCount) {
        this.upload(buffer, vertexCount, 35044);
    }

    public void upload(ByteBuffer buffer, int vertexCount, int type) {
        if (this.id == -1) {
            return;
        }
        this.vertexCount = vertexCount;
        this.bind();
        GL15.glBufferData((int)34962, (ByteBuffer)buffer, (int)type);
        this.unbind();
    }

    public VertexBuffer upload(ByteBuffer buffer) {
        this.upload(buffer, buffer.remaining() / this.format.getVertexSize(), 35044);
        return this;
    }

    public void uploadDynamic(ByteBuffer buffer, int vertexCount) {
        this.upload(buffer, vertexCount, 35048);
    }

    public void uploadDynamic(ByteBuffer buffer) {
        this.upload(buffer, buffer.remaining() / this.format.getVertexSize(), 35048);
    }

    public void uploadStream(ByteBuffer buffer, int vertexCount) {
        this.upload(buffer, vertexCount, 35040);
    }

    public void uploadStream(ByteBuffer buffer) {
        this.upload(buffer, buffer.remaining() / this.format.getVertexSize(), 35040);
    }

    @Override
    public void close() {
        if (this.id >= 0) {
            GL15.glDeleteBuffers((int)this.id);
            this.id = -1;
        }
    }

    public void draw(FloatBuffer floatBuffer) {
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMultMatrix((FloatBuffer)floatBuffer);
        this.draw();
        GL11.glPopMatrix();
    }

    public void draw() {
        GL11.glDrawArrays((int)this.drawMode, (int)0, (int)this.vertexCount);
    }

    public void setupState() {
        this.bind();
        this.format.setupBufferState(0L);
    }

    public void cleanupState() {
        this.format.clearBufferState();
        this.unbind();
    }

    public void render() {
        this.setupState();
        this.draw();
        this.cleanupState();
    }

    public VertexFormat getVertexFormat() {
        return this.format;
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    public int getVertexCount() {
        return this.vertexCount;
    }
}

