/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.core.fml.transformers;

import com.gtnewhorizon.gtnhlib.core.GTNHLibCore;
import com.gtnewhorizon.gtnhlib.core.shared.GTNHLibClassDump;
import com.gtnewhorizon.gtnhlib.core.shared.transformers.TessellatorRedirector;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class TessellatorRedirectorTransformer
implements IClassTransformer {
    private final TessellatorRedirector inner = new TessellatorRedirector(GTNHLibCore.isObf());
    private final String[] exclusions = this.inner.getTransformerExclusions();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        for (String exclusion : this.exclusions) {
            if (!transformedName.startsWith(exclusion)) continue;
            return basicClass;
        }
        if (!this.inner.shouldTransform(basicClass)) {
            return basicClass;
        }
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        boolean changed = this.inner.transformClassNode(transformedName, cn);
        if (changed) {
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            byte[] transformedBytes = cw.toByteArray();
            GTNHLibClassDump.dumpClass(transformedName, basicClass, transformedBytes, this);
            return transformedBytes;
        }
        return basicClass;
    }
}

