/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model.loading;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.gtnewhorizon.gtnhlib.GTNHLibConfig;
import com.gtnewhorizon.gtnhlib.client.model.baked.BakedModel;
import com.gtnewhorizon.gtnhlib.client.model.loading.BackingResourceManager;
import com.gtnewhorizon.gtnhlib.client.model.loading.GlobalResourceManager;
import com.gtnewhorizon.gtnhlib.client.model.loading.ModelDeserializer;
import com.gtnewhorizon.gtnhlib.client.model.loading.ModelResourcePack;
import com.gtnewhorizon.gtnhlib.client.model.loading.ResourceLoc;
import com.gtnewhorizon.gtnhlib.client.model.state.BlockState;
import com.gtnewhorizon.gtnhlib.client.model.state.MissingState;
import com.gtnewhorizon.gtnhlib.client.model.state.StateDeserializer;
import com.gtnewhorizon.gtnhlib.client.model.state.StateModelMap;
import com.gtnewhorizon.gtnhlib.client.model.unbaked.JSONModel;
import com.gtnewhorizon.gtnhlib.client.model.unbaked.MissingModel;
import com.gtnewhorizon.gtnhlib.client.model.unbaked.UnbakedModel;
import com.gtnewhorizon.gtnhlib.concurrent.ThreadsafeCache;
import cpw.mods.fml.common.FMLContainerHolder;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraftforge.client.event.TextureStitchEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelRegistry {
    public static final Logger MODEL_LOGGER = LogManager.getLogger(ModelRegistry.class);
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(StateModelMap.class, (Object)new StateDeserializer()).registerTypeAdapter(JSONModel.class, (Object)new ModelDeserializer()).create();
    private static final ThreadsafeCache<BlockState, BakedModel> BLOCKSTATE_MODEL_CACHE = new ThreadsafeCache(GTNHLibConfig.modelCacheSize, s -> ModelRegistry.bakeModel((BlockState)s), false);
    private static final ThreadsafeCache<ResourceLoc.StateLoc, StateModelMap> STATE_MODEL_MAP_CACHE = new ThreadsafeCache(GTNHLibConfig.modelCacheSize, s -> ((ResourceLoc.StateLoc)s).load(() -> MissingState.MISSING_STATE_MAP, GSON), false);
    private static final ThreadsafeCache<ResourceLoc.ModelLoc, JSONModel> JSON_MODEL_CACHE = new ThreadsafeCache(GTNHLibConfig.modelCacheSize, s -> ModelRegistry.loadAndResolveJSONModel((ResourceLoc.ModelLoc)s), false);
    private static final String[] DEFAULT_STATE_KEYS = new String[]{"meta"};

    private static BakedModel bakeModel(BlockState state) {
        Block block = state.block();
        int meta = state.meta();
        StateModelMap smm = ModelRegistry.getStateModelMap(block);
        Object2ObjectMap<String, String> properties = Object2ObjectMaps.unmodifiable(new Object2ObjectArrayMap(DEFAULT_STATE_KEYS, new String[]{Integer.toString(meta)}));
        UnbakedModel dough = smm.selectModel(properties);
        if (dough == null) {
            return MissingModel.MISSING_MODEL.bake();
        }
        return dough.bake();
    }

    public static BakedModel getBakedModel(BlockState state) {
        return BLOCKSTATE_MODEL_CACHE.get(state);
    }

    public static JSONModel getJSONModel(ResourceLoc.ModelLoc loc) {
        return JSON_MODEL_CACHE.get(loc);
    }

    public static void registerModid(String modid) {
        ReloadListener.PERMITTED_MODIDS.add(modid);
    }

    private static StateModelMap getStateModelMap(Block block) {
        BlockName name = BlockName.fromBlock(block);
        ResourceLoc.StateLoc stateLocation = new ResourceLoc.StateLoc(name.domain, name.name);
        return STATE_MODEL_MAP_CACHE.get(stateLocation);
    }

    private static JSONModel loadAndResolveJSONModel(ResourceLoc.ModelLoc loc) {
        JSONModel m = loc.load(() -> MissingModel.MISSING_MODEL, GSON);
        m.resolveParents(JSON_MODEL_CACHE::get);
        return m;
    }

    public static class ReloadListener
    implements IResourceManagerReloadListener {
        private static final ObjectOpenHashSet<String> PERMITTED_MODIDS = new ObjectOpenHashSet();

        public void onResourceManagerReload(IResourceManager irm) {
            BLOCKSTATE_MODEL_CACHE.clear();
            STATE_MODEL_MAP_CACHE.clear();
            JSON_MODEL_CACHE.clear();
            if (!(irm instanceof GlobalResourceManager)) {
                return;
            }
            GlobalResourceManager manager = (GlobalResourceManager)irm;
            if (GTNHLibConfig.autoTextureLoading) {
                this.detectAndLoadTextures(manager);
            }
        }

        private void detectAndLoadTextures(GlobalResourceManager manager) {
            Map<String, IResourceManager> domains = manager.nhlib$getDomainResourceManagers();
            ObjectOpenHashSet<IResourcePack> resourcePacks = new ObjectOpenHashSet<IResourcePack>();
            for (Map.Entry<String, IResourceManager> entry : domains.entrySet()) {
                IResourceManager files = entry.getValue();
                if (!(files instanceof FallbackResourceManager)) continue;
                resourcePacks.addAll((Collection<IResourcePack>)((BackingResourceManager)files).nhlib$getResourcePacks());
            }
            ObjectArrayList<String> texturesToLoad = new ObjectArrayList<String>();
            for (IResourcePack pack : resourcePacks) {
                FMLContainerHolder fmlch;
                ModelResourcePack mrp;
                if (!(pack instanceof ModelResourcePack) || (mrp = (ModelResourcePack)pack) instanceof FMLContainerHolder && !PERMITTED_MODIDS.contains((fmlch = (FMLContainerHolder)mrp).getFMLContainer().getModId())) continue;
                List<String> texture = mrp.nhlib$getReferencedTextures(reader -> (JSONModel)GSON.fromJson(reader, JSONModel.class));
                texturesToLoad.addAll((Collection<String>)texture);
            }
            EventHandler.texturesToLoad = texturesToLoad;
        }
    }

    private static final class BlockName {
        private final String domain;
        private final String name;

        private BlockName(String domain, String name) {
            this.domain = domain;
            this.name = name;
        }

        private static BlockName fromBlock(Block block) {
            String blockName = Block.blockRegistry.getNameForObject((Object)block);
            int sepIdx = blockName.indexOf(":");
            String domain = blockName.substring(0, sepIdx);
            String name = blockName.substring(sepIdx + 1);
            return new BlockName(domain, name);
        }
    }

    public static class EventHandler {
        private static List<String> texturesToLoad = ObjectLists.emptyList();

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void onTextureStitch(TextureStitchEvent.Pre event) {
            for (String texture : texturesToLoad) {
                event.map.registerIcon(texture.replaceFirst("^minecraft:", ""));
            }
        }
    }
}

