/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.client.renderer.ITessellatorInstance;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuad;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadViewMutable;
import com.gtnewhorizon.gtnhlib.client.renderer.stacks.Vector3dStack;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import com.gtnewhorizon.gtnhlib.util.ObjectPooler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import org.lwjgl.BufferUtils;

public class CapturingTessellator
extends Tessellator
implements ITessellatorInstance {
    final ObjectPooler<ModelQuad> quadBuf = new ObjectPooler<ModelQuad>(ModelQuad::new);
    final List<ModelQuadViewMutable> collectedQuads = new ObjectArrayList<ModelQuadViewMutable>();
    int shaderBlockId = -1;
    final BlockPos offset = new BlockPos();
    final Flags flags = new Flags(true, true, true, true);
    private final Vector3dStack storedTranslation = new Vector3dStack();

    public void setOffset(BlockPos pos) {
        this.offset.set(pos);
    }

    public void resetOffset() {
        this.offset.zero();
    }

    public int draw() {
        return TessellatorManager.processDrawForCapturingTessellator(this);
    }

    @Override
    public void discard() {
        this.isDrawing = false;
        this.reset();
    }

    @Override
    public boolean gtnhlib$isCompiling() {
        return TessellatorManager.isCurrentlyCompiling();
    }

    @Override
    public void gtnhlib$setCompiling(boolean compiling) {
    }

    public List<ModelQuadViewMutable> getQuads() {
        return this.collectedQuads;
    }

    public void clearQuads() {
        for (int i = 0; i < this.collectedQuads.size(); ++i) {
            ModelQuadViewMutable quad = this.collectedQuads.get(i);
            if (!(quad instanceof ModelQuad)) continue;
            ModelQuad mq = (ModelQuad)quad;
            this.quadBuf.releaseInstance(mq);
        }
        this.collectedQuads.clear();
    }

    public static ByteBuffer quadsToBuffer(List<ModelQuadViewMutable> quads, VertexFormat format) {
        if (!format.canWriteQuads()) {
            throw new IllegalStateException("Vertex format has no quad writer: " + format);
        }
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(format.getVertexSize() * quads.size() * 4));
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            format.writeQuad(quads.get(i), byteBuffer);
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    public void storeTranslation() {
        this.storedTranslation.push();
        this.storedTranslation.set(this.xOffset, this.yOffset, this.zOffset);
    }

    public void restoreTranslation() {
        this.xOffset = this.storedTranslation.x;
        this.yOffset = this.storedTranslation.y;
        this.zOffset = this.storedTranslation.z;
        this.storedTranslation.pop();
    }

    public static int createBrightness(int sky, int block) {
        return sky << 20 | block << 4;
    }

    public CapturingTessellator pos(double x, double y, double z) {
        this.ensureBuffer();
        this.rawBuffer[this.rawBufferIndex + 0 + 0] = Float.floatToRawIntBits((float)(x + this.xOffset));
        this.rawBuffer[this.rawBufferIndex + 0 + 1] = Float.floatToRawIntBits((float)(y + this.yOffset));
        this.rawBuffer[this.rawBufferIndex + 0 + 2] = Float.floatToRawIntBits((float)(z + this.zOffset));
        return this;
    }

    public CapturingTessellator tex(double u, double v) {
        this.rawBuffer[this.rawBufferIndex + 3] = Float.floatToRawIntBits((float)u);
        this.rawBuffer[this.rawBufferIndex + 3 + 1] = Float.floatToRawIntBits((float)v);
        this.hasTexture = true;
        return this;
    }

    public CapturingTessellator color(float red, float green, float blue, float alpha) {
        return this.color((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public CapturingTessellator color(int red, int green, int blue, int alpha) {
        if (this.isColorDisabled) {
            return this;
        }
        red = MathHelper.clamp_int((int)red, (int)0, (int)255);
        green = MathHelper.clamp_int((int)green, (int)0, (int)255);
        blue = MathHelper.clamp_int((int)blue, (int)0, (int)255);
        alpha = MathHelper.clamp_int((int)alpha, (int)0, (int)255);
        int color = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? alpha << 24 | blue << 16 | green << 8 | red : red << 24 | green << 16 | blue << 8 | alpha;
        this.rawBuffer[this.rawBufferIndex + 5] = color;
        this.hasColor = true;
        return this;
    }

    public CapturingTessellator normal(float x, float y, float z) {
        byte b0 = (byte)(x * 127.0f);
        byte b1 = (byte)(y * 127.0f);
        byte b2 = (byte)(z * 127.0f);
        this.rawBuffer[this.rawBufferIndex + 6] = b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16;
        this.hasNormals = true;
        return this;
    }

    public CapturingTessellator setNormalTransformed(Vector3f normal, Vector3f dest, Matrix3f normalMatrix) {
        normalMatrix.transform(normal, dest).normalize();
        this.setNormal(dest.x, dest.y, dest.z);
        return this;
    }

    public CapturingTessellator setNormalTransformed(Vector3f normal, Matrix3f normalMatrix) {
        return this.setNormalTransformed(normal, normal, normalMatrix);
    }

    public CapturingTessellator lightmap(int skyLight, int blockLight) {
        return this.brightness(CapturingTessellator.createBrightness(skyLight, blockLight));
    }

    public CapturingTessellator brightness(int brightness) {
        this.rawBuffer[this.rawBufferIndex + 7] = brightness;
        this.hasBrightness = true;
        return this;
    }

    public CapturingTessellator endVertex() {
        this.rawBufferIndex += 8;
        ++this.vertexCount;
        return this;
    }

    public void ensureBuffer() {
        if (this.rawBufferIndex >= this.rawBufferSize - 32) {
            if (this.rawBufferSize == 0) {
                this.rawBufferSize = 65536;
                this.rawBuffer = new int[this.rawBufferSize];
            } else {
                this.rawBufferSize *= 2;
                this.rawBuffer = Arrays.copyOf(this.rawBuffer, this.rawBufferSize);
            }
        }
    }

    public void setShaderBlockId(int blockId) {
        if (this.isDrawing) {
            this.draw();
            this.isDrawing = true;
        }
        this.shaderBlockId = blockId;
    }

    public static class Flags {
        public boolean hasTexture;
        public boolean hasBrightness;
        public boolean hasColor;
        public boolean hasNormals;

        public Flags(boolean hasTexture, boolean hasBrightness, boolean hasColor, boolean hasNormals) {
            this.hasTexture = hasTexture;
            this.hasBrightness = hasBrightness;
            this.hasColor = hasColor;
            this.hasNormals = hasNormals;
        }

        public Flags(Flags other) {
            this.hasTexture = other.hasTexture;
            this.hasBrightness = other.hasBrightness;
            this.hasColor = other.hasColor;
            this.hasNormals = other.hasNormals;
        }

        public void copyFrom(boolean hasTexture, boolean hasBrightness, boolean hasColor, boolean hasNormals) {
            this.hasTexture = hasTexture;
            this.hasBrightness = hasBrightness;
            this.hasColor = hasColor;
            this.hasNormals = hasNormals;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Flags)) {
                return false;
            }
            Flags flags = (Flags)o;
            return this.hasTexture == flags.hasTexture && this.hasBrightness == flags.hasBrightness && this.hasColor == flags.hasColor && this.hasNormals == flags.hasNormals;
        }

        public int hashCode() {
            return Objects.hash(this.hasTexture, this.hasBrightness, this.hasColor, this.hasNormals);
        }
    }
}

