/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.util;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.client.renderer.util.DirectionUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import org.joml.Vector3d;

public class WorldUtil {
    public static Vector3d getVelocity(IBlockAccess world, int x, int y, int z, Block thizz) {
        Vector3d velocity = new Vector3d();
        int decay = WorldUtil.getEffectiveFlowDecay(world, x, y, z, thizz);
        for (ForgeDirection dire : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            int adjX = x + dire.offsetX;
            int adjZ = z + dire.offsetZ;
            int adjDecay = WorldUtil.getEffectiveFlowDecay(world, adjX, y, adjZ, thizz);
            if (adjDecay < 0) {
                if (world.getBlock(adjX, y, adjZ).getMaterial().blocksMovement() || (adjDecay = WorldUtil.getEffectiveFlowDecay(world, adjX, y - 1, adjZ, thizz)) < 0) continue;
                velocity = velocity.add((adjX - x) * (adjDecay -= decay - 8), 0.0, (adjZ - z) * adjDecay);
                continue;
            }
            velocity = velocity.add((adjX - x) * (adjDecay -= decay), 0.0, (adjZ - z) * adjDecay);
        }
        if (world.getBlockMetadata(x, y, z) >= 8 && (thizz.isBlockSolid(world, x, y, z - 1, 2) || thizz.isBlockSolid(world, x, y, z + 1, 3) || thizz.isBlockSolid(world, x - 1, y, z, 4) || thizz.isBlockSolid(world, x + 1, y, z, 5) || thizz.isBlockSolid(world, x, y + 1, z - 1, 2) || thizz.isBlockSolid(world, x, y + 1, z + 1, 3) || thizz.isBlockSolid(world, x - 1, y + 1, z, 4) || thizz.isBlockSolid(world, x + 1, y + 1, z, 5))) {
            velocity = velocity.normalize().add(0.0, -6.0, 0.0);
        }
        if (velocity.x == 0.0 && velocity.y == 0.0 && velocity.z == 0.0) {
            return velocity.zero();
        }
        return velocity.normalize();
    }

    public static boolean method_15756(IBlockAccess world, BlockPos pos, Fluid fluid) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                Block block = world.getBlock(pos.x, pos.y, pos.z);
                if (block.isOpaqueCube() || WorldUtil.getFluid(block) == fluid) continue;
                return true;
            }
        }
        return false;
    }

    public static float getFluidHeight(Fluid fluid, int meta) {
        return fluid == null ? 0.0f : 1.0f - BlockLiquid.getLiquidHeightPercent((int)meta);
    }

    public static int getEffectiveFlowDecay(IBlockAccess world, int x, int y, int z, Block thiz) {
        if (world.getBlock(x, y, z).getMaterial() != thiz.getMaterial()) {
            return -1;
        }
        int decay = world.getBlockMetadata(x, y, z);
        return decay >= 8 ? 0 : decay;
    }

    public static boolean shouldDisplayFluidOverlay(Block block) {
        return !block.getMaterial().isOpaque() || block.getMaterial() == Material.leaves;
    }

    public static boolean isFluidBlock(Block block) {
        return block instanceof IFluidBlock || block instanceof BlockLiquid;
    }

    public static Fluid getFluid(Block b) {
        if (b instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)b;
            return fluidBlock.getFluid();
        }
        if (b instanceof BlockLiquid) {
            if (b.getMaterial() == Material.water) {
                return FluidRegistry.WATER;
            }
            if (b.getMaterial() == Material.lava) {
                return FluidRegistry.LAVA;
            }
        }
        return null;
    }

    public static boolean isEmptyOrSame(Fluid fluid, Fluid otherFluid) {
        return otherFluid == null || fluid == otherFluid;
    }

    public static boolean method_15749(IBlockAccess world, Fluid thiz, BlockPos pos, ForgeDirection dir) {
        Block b = world.getBlock(pos.x, pos.y, pos.z);
        Fluid f = WorldUtil.getFluid(b);
        if (f == thiz) {
            return false;
        }
        if (dir == ForgeDirection.UP) {
            return true;
        }
        return b.getMaterial() != Material.ice && b.isSideSolid(world, pos.x, pos.y, pos.z, dir);
    }
}

