/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.datastructs.spatialhashgrid;

import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.function.BiConsumer;
import org.joml.Vector3i;

public class SpatialHashGrid<T> {
    private final int cellSize;
    private final BiConsumer<Vector3i, T> positionExtractor;
    private final Vector3i scratch = new Vector3i();
    private final Long2ObjectOpenHashMap<ObjectArrayList<T>> grid = new Long2ObjectOpenHashMap();

    public SpatialHashGrid(int cellSize, BiConsumer<Vector3i, T> positionExtractor) {
        if (cellSize <= 0) {
            throw new IllegalArgumentException("cellSize can not be less than or equal to 0");
        }
        this.cellSize = cellSize;
        this.positionExtractor = positionExtractor;
    }

    private long pack(int x, int y, int z) {
        return CoordinatePacker.pack(x, y, z);
    }

    private long hash(int x, int y, int z) {
        return this.pack(Math.floorDiv(x, this.cellSize), Math.floorDiv(y, this.cellSize), Math.floorDiv(z, this.cellSize));
    }

    public void insert(T obj) {
        this.positionExtractor.accept(this.scratch, (Vector3i)obj);
        long key = this.hash(this.scratch.x, this.scratch.y, this.scratch.z);
        ObjectArrayList list = this.grid.computeIfAbsent(key, k -> new ObjectArrayList());
        list.add(obj);
    }

    public void remove(T obj) {
        this.positionExtractor.accept(this.scratch, (Vector3i)obj);
        long key = this.hash(this.scratch.x, this.scratch.y, this.scratch.z);
        ObjectArrayList<T> list = this.grid.get(key);
        if (list == null) {
            return;
        }
        list.remove(obj);
        if (!list.isEmpty()) {
            return;
        }
        this.grid.remove(key);
    }

    public List<T> findNearby(int x, int y, int z, int radius) {
        return this.findNearby(x, y, z, radius, DistanceFormula.SquaredEuclidean);
    }

    public List<T> findNearby(int x, int y, int z, int radius, DistanceFormula distanceFormula) {
        radius = Math.abs(radius);
        int cellX = Math.floorDiv(x, this.cellSize);
        int cellY = Math.floorDiv(y, this.cellSize);
        int cellZ = Math.floorDiv(z, this.cellSize);
        int cellRad = (radius + this.cellSize - 1) / this.cellSize;
        int radiusSquared = radius * radius;
        ObjectArrayList<Object> result = new ObjectArrayList<Object>();
        for (int dx = -cellRad; dx <= cellRad; ++dx) {
            for (int dy = -cellRad; dy <= cellRad; ++dy) {
                for (int dz = -cellRad; dz <= cellRad; ++dz) {
                    boolean isEdge;
                    long key = this.pack(cellX + dx, cellY + dy, cellZ + dz);
                    ObjectArrayList<T> list = this.grid.get(key);
                    if (list == null || list.isEmpty()) continue;
                    boolean bl = isEdge = Math.abs(dx) == cellRad || Math.abs(dy) == cellRad || Math.abs(dz) == cellRad;
                    if (isEdge) {
                        for (Object obj : list) {
                            this.positionExtractor.accept(this.scratch, (Vector3i)obj);
                            if (this.distanceBetweenPoints(x, y, z, this.scratch.x, this.scratch.y, this.scratch.z, distanceFormula) > (double)radiusSquared) continue;
                            result.add(obj);
                        }
                        continue;
                    }
                    result.addAll((ObjectList<Object>)list);
                }
            }
        }
        return result;
    }

    private double distanceBetweenPoints(double x1, double y1, double z1, double x2, double y2, double z2, DistanceFormula distanceFormula) {
        double d;
        switch (distanceFormula) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SquaredEuclidean: {
                d = this.squaredEuclideanDistance(x1, y1, z1, x2, y2, z2);
                break;
            }
            case Chebyshev: {
                d = this.chebyshevDistance(x1, y1, z1, x2, y2, z2);
                break;
            }
            case Manhattan: {
                d = this.manhattanDistance(x1, y1, z1, x2, y2, z2);
            }
        }
        return d;
    }

    private double squaredEuclideanDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    private double manhattanDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.abs(x2 - x1) + Math.abs(y2 - y1) + Math.abs(z2 - z1);
    }

    private double chebyshevDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.max(Math.abs(x2 - x1), Math.max(Math.abs(y2 - y1), Math.abs(z2 - z1)));
    }

    public static enum DistanceFormula {
        SquaredEuclidean,
        Chebyshev,
        Manhattan;

    }
}

