/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util;

import net.minecraft.util.ChunkCoordinates;
import org.joml.Vector3i;

public final class CoordinatePacker {
    private static final int SIZE_BITS_X = 26;
    private static final int SIZE_BITS_Z = 26;
    private static final int SIZE_BITS_Y = 12;
    private static final long BITS_X = 0x3FFFFFFL;
    private static final long BITS_Y = 4095L;
    private static final long BITS_Z = 0x3FFFFFFL;
    private static final int BIT_SHIFT_X = 38;
    private static final int BIT_SHIFT_Z = 12;
    private static final int BIT_SHIFT_Y = 0;

    public static long pack(int x, int y, int z) {
        long l = 0L;
        l |= ((long)x & 0x3FFFFFFL) << 38;
        l |= ((long)y & 0xFFFL) << 0;
        return l |= ((long)z & 0x3FFFFFFL) << 12;
    }

    public static long pack(ChunkCoordinates coords) {
        return CoordinatePacker.pack(coords.posX, coords.posY, coords.posZ);
    }

    public static long pack(Vector3i coords) {
        return CoordinatePacker.pack(coords.x, coords.y, coords.z);
    }

    public static int unpackX(long packed) {
        return (int)(packed << 0 >> 38);
    }

    public static int unpackY(long packed) {
        return (int)(packed << 52 >> 52);
    }

    public static int unpackZ(long packed) {
        return (int)(packed << 26 >> 38);
    }

    public static void unpack(long packed, ChunkCoordinates coords) {
        coords.posX = CoordinatePacker.unpackX(packed);
        coords.posY = CoordinatePacker.unpackY(packed);
        coords.posZ = CoordinatePacker.unpackZ(packed);
    }

    public static void unpack(long packed, Vector3i coords) {
        coords.x = CoordinatePacker.unpackX(packed);
        coords.y = CoordinatePacker.unpackY(packed);
        coords.z = CoordinatePacker.unpackZ(packed);
    }
}

