/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.floats.FloatObjectImmutablePair;
import java.util.Comparator;

public interface FloatObjectPair<V>
extends Pair<Float, V> {
    public float leftFloat();

    @Override
    @Deprecated
    default public Float left() {
        return Float.valueOf(this.leftFloat());
    }

    default public FloatObjectPair<V> left(float l) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public FloatObjectPair<V> left(Float l) {
        return this.left(l.floatValue());
    }

    default public float firstFloat() {
        return this.leftFloat();
    }

    @Override
    @Deprecated
    default public Float first() {
        return Float.valueOf(this.firstFloat());
    }

    default public FloatObjectPair<V> first(float l) {
        return this.left(l);
    }

    @Deprecated
    default public FloatObjectPair<V> first(Float l) {
        return this.first(l.floatValue());
    }

    default public float keyFloat() {
        return this.firstFloat();
    }

    @Override
    @Deprecated
    default public Float key() {
        return Float.valueOf(this.keyFloat());
    }

    default public FloatObjectPair<V> key(float l) {
        return this.left(l);
    }

    @Deprecated
    default public FloatObjectPair<V> key(Float l) {
        return this.key(l.floatValue());
    }

    public static <V> FloatObjectPair<V> of(float left, V right) {
        return new FloatObjectImmutablePair<V>(left, right);
    }

    public static <V> Comparator<FloatObjectPair<V>> lexComparator() {
        return (x, y) -> {
            int t = Float.compare(x.leftFloat(), y.leftFloat());
            if (t != 0) {
                return t;
            }
            return ((Comparable)x.right()).compareTo(y.right());
        };
    }
}

