/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item;

import com.gtnewhorizon.gtnhlib.capability.item.ItemSink;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.InsertionItemStack;
import com.gtnewhorizon.gtnhlib.item.StandardInventoryIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryItemSink
implements ItemSink {
    public final IInventory inv;
    private final ForgeDirection side;
    private int[] allowedSlots;

    public InventoryItemSink(IInventory inv, ForgeDirection side) {
        this.inv = inv;
        this.side = side;
    }

    protected int[] getSlots() {
        IInventory iInventory = this.inv;
        if (iInventory instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)iInventory;
            return sided.getAccessibleSlotsFromSide(this.side.ordinal());
        }
        return IntIterators.unwrap(IntIterators.fromTo(0, this.inv.getSizeInventory()));
    }

    @Override
    public void resetSink() {
        ItemSink.super.resetSink();
        this.allowedSlots = null;
    }

    @Override
    public void setAllowedSinkSlots(int @Nullable [] slots) {
        this.allowedSlots = slots;
    }

    @Override
    public int store(ImmutableItemStack stack) {
        ImmutableItemStack slot;
        if (stack.isEmpty()) {
            return 0;
        }
        StandardInventoryIterator iter = this.sinkIterator();
        InsertionItemStack insertion = new InsertionItemStack(stack);
        while (iter.hasNext()) {
            slot = iter.next();
            if (slot == null || slot.isEmpty()) continue;
            insertion.set(iter.insert(insertion, false));
            if (!insertion.isEmpty()) continue;
            return 0;
        }
        iter.rewind();
        while (iter.hasNext()) {
            slot = iter.next();
            if (slot != null && !slot.isEmpty()) continue;
            insertion.set(iter.insert(insertion, false));
            if (!insertion.isEmpty()) continue;
            return 0;
        }
        return insertion.getStackSize();
    }

    @Override
    @NotNull
    public StandardInventoryIterator sinkIterator() {
        return new StandardInventoryIterator(this.inv, this.side, this.getSlots(), this.allowedSlots){

            @Override
            protected int getSlotStackLimit(int slot, ItemStack stack) {
                return InventoryItemSink.this.getSlotStackLimit(slot, stack);
            }
        };
    }

    protected int getSlotStackLimit(int slot, ItemStack stack) {
        int existingMaxStack;
        int invStackLimit = this.inv.getInventoryStackLimit();
        int n = existingMaxStack = stack == null ? 64 : stack.getMaxStackSize();
        if (invStackLimit > 64) {
            return invStackLimit / 64 * existingMaxStack;
        }
        return Math.min(invStackLimit, existingMaxStack);
    }
}

