/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util;

import com.gtnewhorizon.gtnhlib.capability.CapabilityProvider;
import com.gtnewhorizon.gtnhlib.capability.item.ItemIO;
import com.gtnewhorizon.gtnhlib.capability.item.ItemSink;
import com.gtnewhorizon.gtnhlib.capability.item.ItemSource;
import com.gtnewhorizon.gtnhlib.item.InventoryItemSink;
import com.gtnewhorizon.gtnhlib.item.InventoryItemSource;
import com.gtnewhorizon.gtnhlib.item.WrappedItemIO;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.Contract;

public class ItemUtil {
    private static int counter = 0;
    public static final int WRAP_INVENTORIES = 1 << counter++;
    public static final int FOR_INSERTS = 1 << counter++;
    public static final int FOR_EXTRACTS = 1 << counter++;
    public static final int DEFAULT = WRAP_INVENTORIES | FOR_INSERTS | FOR_EXTRACTS;

    public static int getStackMeta(ItemStack stack) {
        return Items.field_151008_G.getDamage(stack);
    }

    public static boolean isStackEmpty(ItemStack stack) {
        return stack == null || stack.func_77973_b() == null || stack.field_77994_a <= 0;
    }

    public static boolean isStackInvalid(ItemStack stack) {
        return stack == null || stack.func_77973_b() == null || stack.field_77994_a < 0;
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return ItemUtil.areStacksEqual(stack1, stack2, false);
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2, boolean ignoreNBT) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && ItemUtil.doStackMetasMatch(ItemUtil.getStackMeta(stack1), ItemUtil.getStackMeta(stack2)) && (ignoreNBT || Objects.equals(stack1.func_77978_p(), stack2.func_77978_p()));
    }

    public static boolean doStackMetasMatch(int meta1, int meta2) {
        if (meta1 == Short.MAX_VALUE) {
            return true;
        }
        if (meta2 == Short.MAX_VALUE) {
            return true;
        }
        return meta1 == meta2;
    }

    @Contract(value="_, null -> null")
    public static ItemStack copyAmount(int amount, ItemStack stack) {
        if (ItemUtil.isStackInvalid(stack)) {
            return null;
        }
        stack = stack.func_77946_l();
        stack.field_77994_a = amount;
        return stack;
    }

    public static ItemStack copy(ItemStack stack) {
        return stack == null ? null : stack.func_77946_l();
    }

    public static IInventory getChestInventory(TileEntityChest chest) {
        Block block = chest.func_145838_q();
        if (!(block instanceof BlockChest)) {
            return null;
        }
        BlockChest blockChest = (BlockChest)block;
        IInventory inv = blockChest.func_149951_m(chest.func_145831_w(), chest.field_145851_c, chest.field_145848_d, chest.field_145849_e);
        return inv != null ? inv : chest;
    }

    public static IInventory getInventory(Object obj, ForgeDirection side) {
        if (obj instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)obj;
            return ItemUtil.getChestInventory(chest);
        }
        if (obj instanceof IInventory) {
            IInventory inv = (IInventory)obj;
            return inv;
        }
        if (obj instanceof CapabilityProvider) {
            CapabilityProvider capabilityProvider = (CapabilityProvider)obj;
            return capabilityProvider.getCapability(IInventory.class, side);
        }
        return null;
    }

    public static ItemSource getItemSource(Object obj, ForgeDirection side) {
        return ItemUtil.getItemSource(obj, side, DEFAULT);
    }

    public static ItemSource getItemSource(Object obj, ForgeDirection side, int usage) {
        IInventory inv;
        CapabilityProvider capabilityProvider;
        ItemSource source;
        if ((usage & FOR_EXTRACTS) == 0) {
            return null;
        }
        if (obj instanceof ItemSource) {
            ItemSource source2 = (ItemSource)obj;
            return source2;
        }
        if (obj instanceof CapabilityProvider && (source = (capabilityProvider = (CapabilityProvider)obj).getCapability(ItemSource.class, side)) != null) {
            return source;
        }
        if ((usage & WRAP_INVENTORIES) != 0 && (inv = ItemUtil.getInventory(obj, side)) != null) {
            return new InventoryItemSource(inv, side);
        }
        return null;
    }

    public static ItemSink getItemSink(Object obj, ForgeDirection side) {
        return ItemUtil.getItemSink(obj, side, DEFAULT);
    }

    public static ItemSink getItemSink(Object obj, ForgeDirection side, int usage) {
        IInventory inv;
        CapabilityProvider capabilityProvider;
        ItemSink sink;
        if ((usage & FOR_INSERTS) == 0) {
            return null;
        }
        if (obj instanceof ItemSink) {
            ItemSink sink2 = (ItemSink)obj;
            return sink2;
        }
        if (obj instanceof CapabilityProvider && (sink = (capabilityProvider = (CapabilityProvider)obj).getCapability(ItemSink.class, side)) != null) {
            return sink;
        }
        if ((usage & WRAP_INVENTORIES) != 0 && (inv = ItemUtil.getInventory(obj, side)) != null) {
            return new InventoryItemSink(inv, side);
        }
        return null;
    }

    public static ItemIO getItemIO(Object obj, ForgeDirection side) {
        return ItemUtil.getItemIO(obj, side, DEFAULT);
    }

    public static ItemIO getItemIO(Object obj, ForgeDirection side, int usage) {
        CapabilityProvider capabilityProvider;
        ItemIO itemIO;
        if (obj instanceof ItemIO) {
            ItemIO itemIO2 = (ItemIO)obj;
            return itemIO2;
        }
        if (obj instanceof CapabilityProvider && (itemIO = (capabilityProvider = (CapabilityProvider)obj).getCapability(ItemIO.class, side)) != null) {
            return itemIO;
        }
        ItemSource source = ItemUtil.getItemSource(obj, side, usage);
        ItemSink sink = ItemUtil.getItemSink(obj, side, usage);
        if (source == null && sink == null) {
            return null;
        }
        return new WrappedItemIO(source, sink);
    }
}

