/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.commands;

import com.gtnewhorizon.gtnhlib.commands.GTNHClientCommand;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemInHandCommand
extends GTNHClientCommand {
    public String getCommandName() {
        return "iteminhand";
    }

    public List<String> getCommandAliases() {
        return Collections.singletonList("iih");
    }

    public void processCommand(ICommandSender iCommandSender, String[] args) {
        if (iCommandSender instanceof EntityClientPlayerMP) {
            EntityClientPlayerMP player = (EntityClientPlayerMP)iCommandSender;
            ItemStack itemStack = player.getCurrentEquippedItem();
            if (itemStack == null) {
                this.addChatMessage("Hand is empty!");
                return;
            }
            GameRegistry.UniqueIdentifier UID = GameRegistry.findUniqueIdentifierFor((Item)itemStack.getItem());
            this.addChatMessage(EnumChatFormatting.GREEN.toString() + EnumChatFormatting.STRIKETHROUGH + "--------------------" + EnumChatFormatting.RESET + " Item info " + EnumChatFormatting.GREEN + EnumChatFormatting.STRIKETHROUGH + "--------------------");
            this.addChatMessage(String.format(EnumChatFormatting.GREEN + "UnlocalizedName:" + EnumChatFormatting.RESET + " [%s]", itemStack.getUnlocalizedName()));
            if (UID != null) {
                this.addChatMessage(String.format(EnumChatFormatting.GREEN + "RegistryName:" + EnumChatFormatting.RESET + " [%s]", UID));
            }
            this.addChatMessage(String.format(EnumChatFormatting.GREEN + "ItemMeta:" + EnumChatFormatting.RESET + " [%s]", itemStack.getItemDamage()));
            this.printFluidContent(itemStack);
            this.addChatMessage(String.format(EnumChatFormatting.GREEN + "ClassName:" + EnumChatFormatting.RESET + " [%s]", itemStack.getItem().getClass()));
            this.printMTHand(itemStack);
            this.addChatMessage(EnumChatFormatting.GREEN.toString() + EnumChatFormatting.STRIKETHROUGH + "--------------------------------------------------");
        }
    }

    private void printFluidContent(ItemStack itemStack) {
        IFluidContainerItem tFluidContainer;
        FluidStack fluidStack;
        Item item = itemStack.getItem();
        if (item instanceof IFluidContainerItem && (fluidStack = (tFluidContainer = (IFluidContainerItem)item).getFluid(itemStack)) != null) {
            String s = String.format("FluidID: [%d], UnlocName: [%s], Name: [%s]", fluidStack.getFluid().getID(), fluidStack.getFluid().getUnlocalizedName(), fluidStack.getFluid().getName());
            this.addChatMessage(String.format(EnumChatFormatting.GREEN + "FluidContainer:" + EnumChatFormatting.RESET + " [%s]", s));
        }
    }

    private void printMTHand(ItemStack itemStack) {
        StringBuilder result = new StringBuilder();
        result.append('<');
        result.append(Item.itemRegistry.getNameForObject((Object)itemStack.getItem()));
        if (itemStack.getItemDamage() == Short.MAX_VALUE) {
            result.append(":*");
        } else if (itemStack.getItemDamage() > 0) {
            result.append(':').append(itemStack.getItemDamage());
        }
        result.append('>');
        if (itemStack.getTagCompound() != null) {
            result.append(".withTag(");
            result.append(itemStack.getTagCompound().toString());
            result.append(")");
        }
        String msg = result.toString();
        this.addChatMessage(EnumChatFormatting.GREEN + "mt hand: " + EnumChatFormatting.RESET + msg);
        this.copyToClipboard(msg);
    }
}

