/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.datastructs.space;

import com.gtnewhorizon.gtnhlib.datastructs.space.VolumeShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ArrayProximityCheck4D {
    private final List<DimensionData> dimList = new ArrayList<DimensionData>();
    private final VolumeShape shape;

    public ArrayProximityCheck4D(@Nonnull VolumeShape shape) {
        Objects.requireNonNull(shape);
        this.shape = shape;
    }

    private DimensionData getDataForDim(int dim) {
        int size = this.dimList.size();
        for (int i = 0; i < size; ++i) {
            DimensionData dimData = this.dimList.get(i);
            if (dimData.getDimId() != dim) continue;
            return dimData;
        }
        return null;
    }

    public void put(int dim, int x, int y, int z, int radius) {
        if (radius < 0) {
            throw new IllegalArgumentException("Radius must be strictly positive");
        }
        DimensionData dimData = this.getDataForDim(dim);
        if (dimData == null) {
            dimData = new DimensionData(dim);
            this.dimList.add(dimData);
        }
        dimData.put(x, y, z, radius);
    }

    public void remove(int dim, int x, int y, int z) {
        DimensionData dimData = this.getDataForDim(dim);
        if (dimData == null) {
            return;
        }
        dimData.remove(x, y, z);
        if (dimData.isEmpty()) {
            this.dimList.remove(dimData);
        }
    }

    public boolean isInRange(int dim, double x, double y, double z) {
        DimensionData dimData = this.getDataForDim(dim);
        if (dimData == null) {
            return false;
        }
        if (this.shape == VolumeShape.SPHERE) {
            return dimData.isInSphere(x, y, z);
        }
        if (this.shape == VolumeShape.CUBE) {
            return dimData.isInCube(x, y, z);
        }
        throw new IllegalArgumentException("Invalid shape");
    }

    public int size() {
        int size = 0;
        int listSize = this.dimList.size();
        for (int i = 0; i < listSize; ++i) {
            size += this.dimList.get(i).size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.dimList.isEmpty();
    }

    public void clear() {
        this.dimList.clear();
    }

    private static class DimensionData {
        private final int dimId;
        private int[] data;
        private int size;
        private static final int INITIAL_CAPACITY = 8;

        public DimensionData(int dimensionId) {
            this.dimId = dimensionId;
            this.data = new int[32];
            this.size = 0;
        }

        public int getDimId() {
            return this.dimId;
        }

        public int size() {
            return this.size;
        }

        public void put(int x, int y, int z, int radius) {
            int maxIndex = this.size * 4;
            int[] a = this.data;
            for (int i = 0; i < maxIndex; i += 4) {
                if (x != a[i] || y != a[i + 1] || z != a[i + 2]) continue;
                a[i + 3] = radius;
                return;
            }
            if (maxIndex == this.data.length) {
                this.data = Arrays.copyOf(this.data, this.data.length * 2);
            }
            this.data[maxIndex] = x;
            this.data[maxIndex + 1] = y;
            this.data[maxIndex + 2] = z;
            this.data[maxIndex + 3] = radius;
            ++this.size;
        }

        public void remove(int x, int y, int z) {
            int maxIndex = this.size * 4;
            int[] a = this.data;
            for (int i = 0; i < maxIndex; i += 4) {
                if (x != a[i] || y != a[i + 1] || z != a[i + 2]) continue;
                int numMoved = maxIndex - i - 4;
                if (numMoved > 0) {
                    System.arraycopy(this.data, maxIndex - 4, this.data, i, 4);
                }
                --this.size;
                if (this.data.length >= 64 && this.size * 4 < this.data.length / 4) {
                    this.data = Arrays.copyOf(this.data, this.data.length / 2);
                }
                return;
            }
        }

        public boolean isInSphere(double x, double y, double z) {
            int maxIndex = this.size * 4;
            int[] a = this.data;
            for (int i = 0; i < maxIndex; i += 4) {
                double dx = x - (double)a[i] - 0.5;
                double dy = y - (double)a[i + 1] - 0.5;
                double dz = z - (double)a[i + 2] - 0.5;
                double radius = a[i + 3];
                if (!(dx * dx + dy * dy + dz * dz < radius * radius)) continue;
                return true;
            }
            return false;
        }

        public boolean isInCube(double x, double y, double z) {
            int maxIndex = this.size * 4;
            int[] a = this.data;
            for (int i = 0; i < maxIndex; i += 4) {
                double centerX = (double)a[i] + 0.5;
                double centerY = (double)a[i + 1] + 0.5;
                double centerZ = (double)a[i + 2] + 0.5;
                double radius = (double)a[i + 3] + 0.5;
                if (!(centerX - radius < x) || !(x < centerX + radius) || !(centerY - radius < y) || !(y < centerY + radius) || !(centerZ - radius < z) || !(z < centerZ + radius)) continue;
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public String toString() {
            int maxIndex = this.size * 4;
            int[] a = this.data;
            StringBuilder sb = new StringBuilder("DimensionData{");
            sb.append("dimId=").append(this.dimId);
            sb.append(", size=").append(this.size);
            sb.append(", data={");
            for (int i = 0; i < maxIndex; i += 4) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append("{x=").append(a[i]);
                sb.append(", y=").append(a[i + 1]);
                sb.append(", z=").append(a[i + 2]);
                sb.append(", radius=").append(a[i + 3]).append('}');
            }
            sb.append("}}");
            return sb.toString();
        }
    }
}

