/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.vao;

import com.gtnewhorizon.gtnhlib.client.renderer.vao.VAOManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;

public class VertexArrayBuffer
extends VertexBuffer {
    protected final int vaoID = VAOManager.VAO.glGenVertexArrays();

    protected VertexArrayBuffer(VertexFormat format, int drawMode) {
        super(format, drawMode);
        VAOManager.VAO.glBindVertexArray(this.vaoID);
        this.bindVBO();
        format.setupBufferState(0L);
        this.unbindVBO();
        VAOManager.VAO.glBindVertexArray(0);
    }

    @Override
    public void close() {
        super.close();
        if (this.vaoID >= 0) {
            VAOManager.VAO.glDeleteVertexArrays(this.vaoID);
        }
    }

    @Override
    public final void render() {
        VAOManager.VAO.glBindVertexArray(this.vaoID);
        this.draw();
        VAOManager.VAO.glBindVertexArray(0);
    }

    @Override
    public final void bind() {
        VAOManager.VAO.glBindVertexArray(this.vaoID);
    }

    @Override
    public final void unbind() {
        VAOManager.VAO.glBindVertexArray(0);
    }

    @Override
    public final void setupState() {
        this.bind();
    }

    @Override
    public final void cleanupState() {
        this.unbind();
    }

    public int getVaoID() {
        return this.vaoID;
    }
}

