package com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad;

import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.primitive.ModelPrimitiveView;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.properties.ModelQuadFacing;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.properties.ModelQuadFlags;

/**
 * Provides a read-only view of a model quad. For mutable access to a model quad, see {@link ModelQuadViewMutable}.
 * Extends {@link ModelPrimitiveView} for compatibility with the primitive rendering pipeline.
 */
public interface ModelQuadView extends ModelPrimitiveView {

    @Override
    default int getVertexCount() {
        return 4;
    }

    /**
     * @return The x-position of the vertex at index {@param idx}
     */
    @Override
    float getX(int idx);

    /**
     * @return The y-position of the vertex at index {@param idx}
     */
    float getY(int idx);

    /**
     * @return The z-position of the vertex at index {@param idx}
     */
    float getZ(int idx);

    /**
     * @return The integer-encoded color of the vertex at index {@param idx}
     */
    int getColor(int idx);

    /**
     * @return The texture x-coordinate for the vertex at index {@param idx}
     */
    float getTexU(int idx);

    /**
     * @return The texture y-coordinate for the vertex at index {@param idx}
     */
    float getTexV(int idx);

    /**
     * @return The packed lightmap coordinates for the vertex at index {@param idx}, or zero if regular lighting should
     *         be used.
     */
    int getLight(int idx);

    /**
     * @return The integer bit flags containing the {@link ModelQuadFlags} for this quad
     */
    int getFlags();

    /**
     * @return The color index of this quad.
     */
    int getColorIndex();

    /**
     * @return The sprite texture used by this quad, or null if none is attached
     */
    Object celeritas$getSprite();

    /**
     * @return The face used by this quad for lighting effects
     */
    ModelQuadFacing getLightFace();

    /**
     * @return The direction in which this quad is pointing, based on its geometry
     */
    ModelQuadFacing getNormalFace();

    int getForgeNormal(int idx);

    int getComputedFaceNormal();

    /**
     * {@return the normal of vertex 0, if specified, or Embeddium's autogenerated face normal otherwise}
     */
    default int getModFaceNormal() {
        int normal = getForgeNormal(0);
        return normal != 0 ? normal : getComputedFaceNormal();
    }

    default boolean hasColor() {
        return this.getColorIndex() != -1;
    }

    default boolean hasAmbientOcclusion() {
        return true;
    }

    default int getVanillaLightEmission() {
        return 0;
    }

    int getShaderBlockId();
}
