/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.client.renderer.ITessellatorInstance;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.Quad;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.QuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.stacks.Vector3dStack;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import com.gtnewhorizon.gtnhlib.util.ObjectPooler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import org.lwjgl.BufferUtils;

public class CapturingTessellator
extends Tessellator
implements ITessellatorInstance {
    private static final MethodHandle sRawBufferSize;
    private static final MethodHandle gRawBufferSize;
    private final Quad.Flags FLAGS = new Quad.Flags(true, true, true, true);
    private final ObjectPooler<QuadView> quadBuf = new ObjectPooler<QuadView>(Quad::new);
    private final List<QuadView> collectedQuads = new ObjectArrayList<QuadView>();
    private int shaderBlockId = -1;
    private final BlockPos offset = new BlockPos();
    private final Vector3dStack storedTranslation = new Vector3dStack();

    public void setOffset(BlockPos pos) {
        this.offset.set(pos);
    }

    public void resetOffset() {
        this.offset.zero();
    }

    public void setRawBufferSize(int size) {
        try {
            sRawBufferSize.invokeExact(this, size);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public int getRawBufferSize() {
        try {
            return gRawBufferSize.invokeExact(this);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public int draw() {
        this.FLAGS.hasBrightness = this.hasBrightness;
        this.FLAGS.hasColor = this.hasColor;
        this.FLAGS.hasNormals = this.hasNormals;
        int verticesPerPrimitive = this.drawMode == 7 ? 4 : 3;
        for (int quadI = 0; quadI < this.vertexCount / verticesPerPrimitive; ++quadI) {
            QuadView quad = this.quadBuf.getInstance();
            quad.setState(this.rawBuffer, quadI * (verticesPerPrimitive * 8), this.FLAGS, this.drawMode, -this.offset.x, -this.offset.y, -this.offset.z);
            quad.setShaderBlockId(this.shaderBlockId);
            if (quad.isDeleted()) {
                this.quadBuf.releaseInstance(quad);
                continue;
            }
            this.collectedQuads.add(quad);
        }
        int i = this.rawBufferIndex * 4;
        this.discard();
        return i;
    }

    @Override
    public void discard() {
        this.isDrawing = false;
        this.reset();
    }

    public List<QuadView> getQuads() {
        return this.collectedQuads;
    }

    public void clearQuads() {
        for (int i = 0; i < this.collectedQuads.size(); ++i) {
            this.quadBuf.releaseInstance(this.collectedQuads.get(i));
        }
        this.collectedQuads.clear();
    }

    public static ByteBuffer quadsToBuffer(List<QuadView> quads, VertexFormat format) {
        if (!format.canWriteQuads()) {
            throw new IllegalStateException("Vertex format has no quad writer: " + format);
        }
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(format.getVertexSize() * quads.size() * 4));
        int quadsSize = quads.size();
        for (int i = 0; i < quadsSize; ++i) {
            format.writeQuad(quads.get(i), byteBuffer);
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    public void storeTranslation() {
        this.storedTranslation.push();
        this.storedTranslation.set(this.xOffset, this.yOffset, this.zOffset);
    }

    public void restoreTranslation() {
        this.xOffset = this.storedTranslation.x;
        this.yOffset = this.storedTranslation.y;
        this.zOffset = this.storedTranslation.z;
        this.storedTranslation.pop();
    }

    public static int createBrightness(int sky, int block) {
        return sky << 20 | block << 4;
    }

    public CapturingTessellator pos(double x, double y, double z) {
        this.ensureBuffer();
        this.rawBuffer[this.rawBufferIndex + 0] = Float.floatToRawIntBits((float)(x + this.xOffset));
        this.rawBuffer[this.rawBufferIndex + 1] = Float.floatToRawIntBits((float)(y + this.yOffset));
        this.rawBuffer[this.rawBufferIndex + 2] = Float.floatToRawIntBits((float)(z + this.zOffset));
        return this;
    }

    public CapturingTessellator tex(double u, double v) {
        this.rawBuffer[this.rawBufferIndex + 3] = Float.floatToRawIntBits((float)u);
        this.rawBuffer[this.rawBufferIndex + 4] = Float.floatToRawIntBits((float)v);
        this.hasTexture = true;
        return this;
    }

    public CapturingTessellator color(float red, float green, float blue, float alpha) {
        return this.color((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public CapturingTessellator color(int red, int green, int blue, int alpha) {
        if (this.isColorDisabled) {
            return this;
        }
        red = MathHelper.clamp_int((int)red, (int)0, (int)255);
        green = MathHelper.clamp_int((int)green, (int)0, (int)255);
        blue = MathHelper.clamp_int((int)blue, (int)0, (int)255);
        alpha = MathHelper.clamp_int((int)alpha, (int)0, (int)255);
        int color = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? alpha << 24 | blue << 16 | green << 8 | red : red << 24 | green << 16 | blue << 8 | alpha;
        this.rawBuffer[this.rawBufferIndex + 5] = color;
        this.hasColor = true;
        return this;
    }

    public CapturingTessellator normal(float x, float y, float z) {
        byte b0 = (byte)(x * 127.0f);
        byte b1 = (byte)(y * 127.0f);
        byte b2 = (byte)(z * 127.0f);
        this.rawBuffer[this.rawBufferIndex + 6] = b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16;
        this.hasNormals = true;
        return this;
    }

    public CapturingTessellator lightmap(int skyLight, int blockLight) {
        return this.brightness(CapturingTessellator.createBrightness(skyLight, blockLight));
    }

    public CapturingTessellator brightness(int brightness) {
        this.rawBuffer[this.rawBufferIndex + 7] = brightness;
        this.hasBrightness = true;
        return this;
    }

    public CapturingTessellator endVertex() {
        this.rawBufferIndex += 8;
        ++this.vertexCount;
        return this;
    }

    public void ensureBuffer() {
        int rawBufferSize = this.getRawBufferSize();
        if (this.rawBufferIndex >= rawBufferSize - 32) {
            if (rawBufferSize == 0) {
                rawBufferSize = 65536;
                this.setRawBufferSize(rawBufferSize);
                this.rawBuffer = new int[rawBufferSize];
            } else {
                this.setRawBufferSize(rawBufferSize *= 2);
                this.rawBuffer = Arrays.copyOf(this.rawBuffer, rawBufferSize);
            }
        }
    }

    public void setShaderBlockId(int blockId) {
        if (this.isDrawing) {
            this.draw();
            this.isDrawing = true;
        }
        this.shaderBlockId = blockId;
    }

    static {
        Field rbs = ReflectionHelper.findField(Tessellator.class, (String[])new String[]{"rawBufferSize", "field_78388_E"});
        rbs.setAccessible(true);
        try {
            sRawBufferSize = MethodHandles.lookup().unreflectSetter(rbs);
            gRawBufferSize = MethodHandles.lookup().unreflectGetter(rbs);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

