/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EarlyConfig {
    private static final Logger LOGGER;
    public static final boolean enableFontRendererMixin;

    static {
        Closeable r;
        LOGGER = LogManager.getLogger((String)"GTNHLibEarly");
        Properties config = new Properties();
        File configLocation = new File(Launch.minecraftHome, "config/gtnhlibEarly.properties");
        try {
            r = new BufferedReader(new FileReader(configLocation));
            try {
                config.load((Reader)r);
            }
            finally {
                ((Reader)r).close();
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("No existing configuration file. Will use defaults");
        }
        catch (IOException e) {
            LOGGER.error("Error reading configuration file. Will use defaults", (Throwable)e);
        }
        enableFontRendererMixin = Boolean.parseBoolean(config.getProperty("enableFontRendererMixin", "true"));
        config.setProperty("enableFontRendererMixin", String.valueOf(enableFontRendererMixin));
        try {
            r = new BufferedWriter(new FileWriter(configLocation));
            try {
                config.store((Writer)r, "Config file for anything that's loaded before GTNHLibConfig");
            }
            finally {
                ((Writer)r).close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Error writing configuration file", (Throwable)e);
        }
    }
}

