/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib;

import com.gtnewhorizon.gtnhlib.CommonProxy;
import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizon.gtnhlib.client.model.ModelLoader;
import com.gtnewhorizon.gtnhlib.client.tooltip.LoreHandler;
import com.gtnewhorizon.gtnhlib.commands.ItemInHandCommand;
import com.gtnewhorizon.gtnhlib.compat.FalseTweaks;
import com.gtnewhorizon.gtnhlib.compat.Mods;
import com.gtnewhorizon.gtnhlib.compat.NotEnoughItemsVersionChecker;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import com.gtnewhorizon.gtnhlib.util.AboveHotbarHUD;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.ClientCommandHandler;

@EventBusSubscriber(side={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static boolean modelsBaked = false;
    public static boolean doThreadSafetyChecks = true;
    public static int currentServerViewDistance = 12;
    private final Minecraft mc = Minecraft.getMinecraft();

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        ClientCommandHandler.instance.registerCommand((ICommand)new ItemInHandCommand());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        if (Mods.FALSETWEAKS && !(doThreadSafetyChecks = FalseTweaks.doTessSafetyChecks())) {
            GTNHLib.info("FalseTweaks threaded rendering is enabled - disabling GTNHLib's thread safety checks");
        }
        if (Mods.NEI) {
            FMLCommonHandler.instance().bus().register((Object)new NotEnoughItemsVersionChecker());
        }
        if (ModelLoader.shouldLoadModels()) {
            Minecraft.getMinecraft().refreshResources();
            ModelLoader.loadModels();
        }
        LoreHandler.postInit();
    }

    @Override
    public void addDebugToChat(String message) {
        this.addDebugToChat((IChatComponent)new ChatComponentText(message));
    }

    @Override
    public void addDebugToChat(IChatComponent componentText) {
        this.addMessageToChat(new ChatComponentText(EnumChatFormatting.YELLOW + "[Debug]: ").appendSibling(componentText));
    }

    @Override
    public void addInfoToChat(String message) {
        this.addInfoToChat((IChatComponent)new ChatComponentText(message));
    }

    @Override
    public void addInfoToChat(IChatComponent componentText) {
        this.addMessageToChat(new ChatComponentText(EnumChatFormatting.GREEN + "[Info]: ").appendSibling(componentText));
    }

    @Override
    public void addWarnToChat(String message) {
        this.addWarnToChat((IChatComponent)new ChatComponentText(message));
    }

    @Override
    public void addWarnToChat(IChatComponent componentText) {
        this.addMessageToChat(new ChatComponentText(EnumChatFormatting.LIGHT_PURPLE + "[Warn]: ").appendSibling(componentText));
    }

    @Override
    public void addErrorToChat(String message) {
        this.addErrorToChat((IChatComponent)new ChatComponentText(message));
    }

    @Override
    public void addErrorToChat(IChatComponent componentText) {
        this.addMessageToChat(new ChatComponentText(EnumChatFormatting.RED + "[Error]: ").appendSibling(componentText));
    }

    @Override
    public void addMessageToChat(IChatComponent componentText) {
        if (this.mc.theWorld != null && this.mc.thePlayer != null) {
            this.mc.thePlayer.addChatMessage(componentText);
        }
    }

    @Override
    public void printMessageAboveHotbar(String message, int displayDuration, boolean drawShadow, boolean shouldFade) {
        AboveHotbarHUD.renderTextAboveHotbar(message, displayDuration, drawShadow, shouldFade);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (!modelsBaked) {
            ModelLoader.bakeModels();
            modelsBaked = true;
        }
    }

    @Generated
    public static int getCurrentServerViewDistance() {
        return currentServerViewDistance;
    }
}

