/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item;

import com.gtnewhorizon.gtnhlib.capability.item.ItemSource;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.ItemStack2IntFunction;
import com.gtnewhorizon.gtnhlib.item.ItemStackPredicate;
import com.gtnewhorizon.gtnhlib.item.StandardInventoryIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryItemSource
implements ItemSource {
    public final IInventory inv;
    public final ForgeDirection side;
    private int[] allowedSlots;

    public InventoryItemSource(IInventory inv, ForgeDirection side) {
        this.inv = inv;
        this.side = side;
    }

    protected int[] getSlots() {
        IInventory iInventory = this.inv;
        if (iInventory instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)iInventory;
            return sided.getAccessibleSlotsFromSide(this.side.ordinal());
        }
        return IntIterators.unwrap(IntIterators.fromTo(0, this.inv.getSizeInventory()));
    }

    @Override
    public void resetSource() {
        ItemSource.super.resetSource();
        this.allowedSlots = null;
    }

    @Override
    public void setAllowedSourceSlots(int[] slots) {
        this.allowedSlots = slots;
    }

    @Override
    @Nullable
    public ItemStack pull(@Nullable ItemStackPredicate filter, @Nullable ItemStack2IntFunction amount) {
        StandardInventoryIterator iter = this.sourceIterator();
        while (iter.hasNext()) {
            int toExtract;
            ImmutableItemStack slot = iter.next();
            if (slot == null || slot.isEmpty() || filter != null && !filter.test(slot) || (toExtract = amount == null ? slot.getStackSize() : amount.apply(slot)) <= 0) continue;
            return iter.extract(toExtract, false);
        }
        return null;
    }

    @Override
    @NotNull
    public StandardInventoryIterator sourceIterator() {
        return new StandardInventoryIterator(this.inv, this.side, this.getSlots(), this.allowedSlots){

            @Override
            protected int getSlotStackLimit(int slot, ItemStack stack) {
                return InventoryItemSource.this.getSlotStackLimit(slot, stack);
            }
        };
    }

    protected int getSlotStackLimit(int slot, ItemStack stack) {
        int existingMaxStack;
        int invStackLimit = this.inv.getInventoryStackLimit();
        int n = existingMaxStack = stack == null ? 64 : stack.getMaxStackSize();
        if (invStackLimit > 64) {
            return invStackLimit / 64 * existingMaxStack;
        }
        return Math.min(invStackLimit, existingMaxStack);
    }
}

