/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model;

import com.gtnewhorizon.gtnhlib.client.model.NormalHelper;
import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BakedModelBuilder {
    private float textureWidth;
    private float textureHeight;
    private int textureOffsetX;
    private int textureOffsetY;
    private float rotationPointX;
    private float rotationPointY;
    private float rotationPointZ;
    private float rotateAngleX;
    private float rotateAngleY;
    private float rotateAngleZ;
    private boolean mirror;
    private final CapturingTessellator tessellator;
    private final Matrix4f modelMatrix = new Matrix4f();

    public BakedModelBuilder(int textureWidth, int textureHeight) {
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        TessellatorManager.startCapturing();
        this.tessellator = (CapturingTessellator)TessellatorManager.get();
        this.tessellator.startDrawing(7);
    }

    public BakedModelBuilder(ModelBase model) {
        this(model.textureWidth, model.textureHeight);
    }

    public BakedModelBuilder(ModelBase model, int textureOffsetX, int textureOffsetY) {
        this(model);
        this.setTextureOffset(textureOffsetX, textureOffsetY);
    }

    public BakedModelBuilder setTextureOffset(int textureOffsetX, int textureOffsetY) {
        this.textureOffsetX = textureOffsetX;
        this.textureOffsetY = textureOffsetY;
        return this;
    }

    public BakedModelBuilder setTextureSize(int textureWidth, int textureHeight) {
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        return this;
    }

    public BakedModelBuilder setRotationPoint(float rotationPointX, float rotationPointY, float rotationPointZ) {
        this.rotationPointX = rotationPointX;
        this.rotationPointY = rotationPointY;
        this.rotationPointZ = rotationPointZ;
        return this;
    }

    public BakedModelBuilder setRotationAngles(float x, float y, float z) {
        this.rotateAngleX = x;
        this.rotateAngleY = y;
        this.rotateAngleZ = z;
        return this;
    }

    public BakedModelBuilder setRotationAngleX(float x) {
        this.rotateAngleX = x;
        return this;
    }

    public BakedModelBuilder setRotationAngleY(float y) {
        this.rotateAngleY = y;
        return this;
    }

    public BakedModelBuilder setRotationAngleZ(float z) {
        this.rotateAngleZ = z;
        return this;
    }

    public BakedModelBuilder setMirrored() {
        this.mirror = true;
        return this;
    }

    public BakedModelBuilder setMirrored(boolean mirror) {
        this.mirror = mirror;
        return this;
    }

    public void addBoxVertices(float x1, float y1, float z1, int xWidth, int yWidth, int zWidth, float scale) {
        this.addBoxVertices(x1, y1, z1, xWidth, yWidth, zWidth, this.getModelMatrix(scale), scale);
    }

    public void addBoxVertices(float x1, float y1, float z1, int xWidth, int yWidth, int zWidth, Matrix4f mat4f, float scale) {
        new ModelBox(this, this.textureOffsetX, this.textureOffsetY, x1, y1, z1, xWidth, yWidth, zWidth).addVerticesToTesselator(this.tessellator, mat4f, scale);
    }

    public Matrix4f getModelMatrix(float scale) {
        Matrix4f mat4f = this.modelMatrix.identity();
        mat4f.translate(this.rotationPointX * scale, this.rotationPointY * scale, this.rotationPointZ * scale);
        if (this.rotateAngleZ != 0.0f) {
            mat4f.rotate(this.rotateAngleZ, 0.0f, 0.0f, 1.0f);
        }
        if (this.rotateAngleY != 0.0f) {
            mat4f.rotate(this.rotateAngleY, 0.0f, 1.0f, 0.0f);
        }
        if (this.rotateAngleX != 0.0f) {
            mat4f.rotate(this.rotateAngleX, 1.0f, 0.0f, 0.0f);
        }
        return mat4f;
    }

    public VertexBuffer finish(VertexFormat format) {
        return TessellatorManager.stopCapturingToVBO(format);
    }

    private static class ModelBox {
        private final TexturedQuad[] quadList = new TexturedQuad[6];

        public ModelBox(BakedModelBuilder builder, int texOffsetX, int texOffsetY, float minX, float minY, float minZ, int xWidth, int yWidth, int zWidth) {
            float maxX = minX + (float)xWidth;
            float maxY = minY + (float)yWidth;
            float maxZ = minZ + (float)zWidth;
            if (builder.mirror) {
                float temp = maxX;
                maxX = minX;
                minX = temp;
            }
            PositionTextureVertex positiontexturevertex7 = new PositionTextureVertex(minX, minY, minZ, 0.0f, 0.0f);
            PositionTextureVertex positiontexturevertex = new PositionTextureVertex(maxX, minY, minZ, 0.0f, 8.0f);
            PositionTextureVertex positiontexturevertex1 = new PositionTextureVertex(maxX, maxY, minZ, 8.0f, 8.0f);
            PositionTextureVertex positiontexturevertex2 = new PositionTextureVertex(minX, maxY, minZ, 8.0f, 0.0f);
            PositionTextureVertex positiontexturevertex3 = new PositionTextureVertex(minX, minY, maxZ, 0.0f, 0.0f);
            PositionTextureVertex positiontexturevertex4 = new PositionTextureVertex(maxX, minY, maxZ, 0.0f, 8.0f);
            PositionTextureVertex positiontexturevertex5 = new PositionTextureVertex(maxX, maxY, maxZ, 8.0f, 8.0f);
            PositionTextureVertex positiontexturevertex6 = new PositionTextureVertex(minX, maxY, maxZ, 8.0f, 0.0f);
            this.quadList[0] = new TexturedQuad(new PositionTextureVertex[]{positiontexturevertex4, positiontexturevertex, positiontexturevertex1, positiontexturevertex5}, texOffsetX + zWidth + xWidth, texOffsetY + zWidth, texOffsetX + zWidth + xWidth + zWidth, texOffsetY + zWidth + yWidth, builder.textureWidth, builder.textureHeight);
            this.quadList[1] = new TexturedQuad(new PositionTextureVertex[]{positiontexturevertex7, positiontexturevertex3, positiontexturevertex6, positiontexturevertex2}, texOffsetX, texOffsetY + zWidth, texOffsetX + zWidth, texOffsetY + zWidth + yWidth, builder.textureWidth, builder.textureHeight);
            this.quadList[2] = new TexturedQuad(new PositionTextureVertex[]{positiontexturevertex4, positiontexturevertex3, positiontexturevertex7, positiontexturevertex}, texOffsetX + zWidth, texOffsetY, texOffsetX + zWidth + xWidth, texOffsetY + zWidth, builder.textureWidth, builder.textureHeight);
            this.quadList[3] = new TexturedQuad(new PositionTextureVertex[]{positiontexturevertex1, positiontexturevertex2, positiontexturevertex6, positiontexturevertex5}, texOffsetX + zWidth + xWidth, texOffsetY + zWidth, texOffsetX + zWidth + xWidth + xWidth, texOffsetY, builder.textureWidth, builder.textureHeight);
            this.quadList[4] = new TexturedQuad(new PositionTextureVertex[]{positiontexturevertex, positiontexturevertex7, positiontexturevertex2, positiontexturevertex1}, texOffsetX + zWidth, texOffsetY + zWidth, texOffsetX + zWidth + yWidth, texOffsetY + zWidth + yWidth, builder.textureWidth, builder.textureHeight);
            this.quadList[5] = new TexturedQuad(new PositionTextureVertex[]{positiontexturevertex3, positiontexturevertex4, positiontexturevertex5, positiontexturevertex6}, texOffsetX + zWidth + yWidth + zWidth, texOffsetY + zWidth, texOffsetX + zWidth + yWidth + zWidth + yWidth, texOffsetY + zWidth + yWidth, builder.textureWidth, builder.textureHeight);
            if (builder.mirror) {
                for (TexturedQuad texturedQuad : this.quadList) {
                    texturedQuad.flipFace();
                }
            }
        }

        public void addVerticesToTesselator(CapturingTessellator tessellator, Matrix4f mat4f, float scale) {
            Vector3f vec3f = new Vector3f();
            Vector4f vec4f = new Vector4f();
            Matrix3f normalMat = NormalHelper.getNormalMatrix(mat4f);
            for (TexturedQuad quad : this.quadList) {
                PositionTextureVertex[] vertices = quad.vertexPositions;
                Vec3 v1 = vertices[1].vector3D;
                Vec3 vec3 = v1.subtract(vertices[0].vector3D);
                Vec3 vec31 = v1.subtract(vertices[2].vector3D);
                Vec3 cross = vec31.crossProduct(vec3);
                vec3f.x = (float)cross.xCoord;
                vec3f.y = (float)cross.yCoord;
                vec3f.z = (float)cross.zCoord;
                tessellator.setNormalTransformed(vec3f, normalMat);
                for (int i = 3; i >= 0; --i) {
                    PositionTextureVertex vertex = quad.vertexPositions[i];
                    ModelBox.addVertexWithUV(tessellator, vec4f, mat4f, (float)(vertex.vector3D.xCoord * (double)scale), (float)(vertex.vector3D.yCoord * (double)scale), (float)(vertex.vector3D.zCoord * (double)scale), vertex.texturePositionX, vertex.texturePositionY);
                }
            }
        }

        private static void addVertexWithUV(Tessellator tessellator, Vector4f vec, Matrix4f mat4f, float x, float y, float z, float u, float v) {
            vec.x = x;
            vec.y = y;
            vec.z = z;
            vec.w = 1.0f;
            vec.mul(mat4f);
            tessellator.addVertexWithUV((double)vec.x, (double)vec.y, (double)vec.z, (double)u, (double)v);
        }
    }
}

