/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.capability.item;

import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.InsertionItemStack;
import com.gtnewhorizon.gtnhlib.item.InventoryIterator;
import com.gtnewhorizon.gtnhlib.item.ItemStackPredicate;
import java.util.OptionalInt;
import javax.annotation.Nonnegative;
import org.jetbrains.annotations.Nullable;

public interface ItemSink {
    public static final OptionalInt ZERO = OptionalInt.of(0);

    default public void resetSink() {
    }

    @Nonnegative
    public int store(ImmutableItemStack var1);

    @Nullable
    default public InventoryIterator sinkIterator() {
        return null;
    }

    default public void setAllowedSinkSlots(int @Nullable [] slots) {
    }

    default public OptionalInt getStoredItemsInSink(@Nullable ItemStackPredicate filter) {
        InventoryIterator iter = this.sinkIterator();
        if (iter == null) {
            return OptionalInt.empty();
        }
        long total = 0L;
        while (iter.hasNext()) {
            ImmutableItemStack stack = (ImmutableItemStack)iter.next();
            if (filter != null && !filter.test(stack)) continue;
            total += (long)stack.getStackSize();
        }
        return total == 0L ? ZERO : OptionalInt.of((int)Math.min(Integer.MAX_VALUE, total));
    }

    default public ItemSink then(ItemSink next) {
        return stack -> {
            int rejected = this.store(stack);
            if (rejected == 0) {
                return 0;
            }
            return next.store(new InsertionItemStack(stack, rejected));
        };
    }

    public static ItemSink chain(ItemSink first, ItemSink second) {
        if (first == null || second == null) {
            return first != null ? first : second;
        }
        return first.then(second);
    }
}

