/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer;

import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadViewMutable;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.VAOManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;

public class TessellatorManager {
    private static final ThreadLocal<CapturingTessellator> capturingTessellator = ThreadLocal.withInitial(CapturingTessellator::new);
    private static final ThreadLocal<Boolean> currentlyCapturing = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final Thread mainThread = Thread.currentThread();

    public static Tessellator get() {
        if (currentlyCapturing.get().booleanValue()) {
            return capturingTessellator.get();
        }
        if (TessellatorManager.isOnMainThread()) {
            return Tessellator.field_78398_a;
        }
        throw new IllegalStateException("Tried to get the Tessellator off the main thread when not capturing!");
    }

    public static boolean isCurrentlyCapturing() {
        return currentlyCapturing.get();
    }

    public static boolean isOnMainThread() {
        return Thread.currentThread() == mainThread;
    }

    public static boolean isMainInstance(Object instance) {
        return instance == Tessellator.field_78398_a || TessellatorManager.isOnMainThread();
    }

    public static void startCapturing() {
        TessellatorManager.startCapturingAndGet();
    }

    public static CapturingTessellator startCapturingAndGet() {
        if (currentlyCapturing.get().booleanValue()) {
            throw new IllegalStateException("Tried to start capturing when already capturing!");
        }
        CapturingTessellator tess = capturingTessellator.get();
        if (!tess.getQuads().isEmpty()) {
            throw new IllegalStateException("Tried to start capturing with existing collected Quads!");
        }
        tess.storeTranslation();
        currentlyCapturing.set(true);
        return tess;
    }

    public static List<ModelQuadViewMutable> stopCapturingToPooledQuads() {
        if (!currentlyCapturing.get().booleanValue()) {
            throw new IllegalStateException("Tried to stop capturing when not capturing!");
        }
        currentlyCapturing.set(false);
        CapturingTessellator tess = capturingTessellator.get();
        if (tess.field_78415_z) {
            tess.func_78381_a();
        }
        List<ModelQuadViewMutable> quads = tess.getQuads();
        tess.discard();
        tess.restoreTranslation();
        return quads;
    }

    public static ByteBuffer stopCapturingToBuffer(VertexFormat format) {
        ByteBuffer buf = CapturingTessellator.quadsToBuffer(TessellatorManager.stopCapturingToPooledQuads(), format);
        capturingTessellator.get().clearQuads();
        return buf;
    }

    public static VertexBuffer stopCapturingToVBO(VertexFormat format) {
        return new VertexBuffer(format, 7).upload(TessellatorManager.stopCapturingToBuffer(format));
    }

    public static VertexBuffer stopCapturingToVAO(VertexFormat format) {
        return VAOManager.createVAO(format, 7).upload(TessellatorManager.stopCapturingToBuffer(format));
    }

    public static void cleanup() {
        CapturingTessellator tessellator = capturingTessellator.get();
        currentlyCapturing.set(false);
        tessellator.discard();
        tessellator.clearQuads();
    }

    static {
        System.out.println("[TessellatorManager] Initialized on thread " + mainThread.getName());
    }
}

