/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.postprocessing;

import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.compat.Mods;
import net.coderbot.iris.rendertarget.IRenderTargetExt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.GL11;

public class PostProcessingHelper {
    private static VertexBuffer fullscreenQuadVAO;

    public static void bindFullscreenVAO() {
        if (fullscreenQuadVAO == null) {
            fullscreenQuadVAO = PostProcessingHelper.genFullscreenQuadVAO();
        }
        fullscreenQuadVAO.bind();
    }

    public static void drawFullscreenQuad() {
        fullscreenQuadVAO.draw();
    }

    public static void unbindVAO() {
        fullscreenQuadVAO.unbind();
    }

    public static void setupPostProcessingGL() {
        PostProcessingHelper.bindFullscreenVAO();
        GL11.glBindTexture((int)3553, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDisable((int)3008);
    }

    public static void clearPostProcessingGL() {
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        PostProcessingHelper.unbindVAO();
    }

    public static int getDepthTexture() {
        return PostProcessingHelper.getDepthTexture(Minecraft.func_71410_x().func_147110_a());
    }

    public static int getDepthTexture(Framebuffer framebuffer) {
        if (!Mods.ANGELICA) {
            throw new UnsupportedOperationException("The depth texture requires Angelica to be loaded.");
        }
        return ((IRenderTargetExt)framebuffer).iris$getDepthTextureId();
    }

    private static VertexBuffer genFullscreenQuadVAO() {
        CapturingTessellator tessellator = TessellatorManager.startCapturingAndGet();
        tessellator.func_78382_b();
        tessellator.func_78374_a(-1.0, -1.0, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(1.0, -1.0, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(1.0, 1.0, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(-1.0, 1.0, 0.0, 0.0, 1.0);
        tessellator.func_78381_a();
        return TessellatorManager.stopCapturingToVAO(DefaultVertexFormat.POSITION_TEXTURE);
    }
}

