/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.datastructs.caches;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.time.Duration;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public class TimedCache<K, V> {
    private final Object2ObjectOpenHashMap<K, Entry<K, V>> values = new Object2ObjectOpenHashMap();
    private final Generation<K, V>[] generations;
    private final Function<K, V> fetcher;
    @Nullable
    private final BiConsumer<K, V> release;
    @Nullable
    private final Function<K, K> clone;

    public TimedCache(Function<K, V> fetcher, Duration gen0Timeout) {
        this(fetcher, TimedCache.getDefaultTimeouts(gen0Timeout), null, null);
    }

    public TimedCache(Function<K, V> fetcher, Duration[] generationTimeouts, @Nullable BiConsumer<K, V> release, @Nullable Function<K, K> clone) {
        this.fetcher = fetcher;
        this.release = release;
        this.clone = clone;
        this.generations = new Generation[generationTimeouts.length];
        for (int i = 0; i < generationTimeouts.length; ++i) {
            this.generations[i] = new Generation(generationTimeouts[i].toNanos());
        }
    }

    private static Duration[] getDefaultTimeouts(Duration gen0) {
        Duration[] genTimeouts = new Duration[]{gen0, Duration.ofNanos(gen0.toNanos() * 10L), Duration.ofNanos(gen0.toNanos() * 100L)};
        return genTimeouts;
    }

    public final V get(K key) {
        long now = System.nanoTime();
        Entry<K, V> entry = this.values.get(key);
        if (entry == null) {
            if (this.clone != null) {
                key = this.clone.apply(key);
            }
            entry = new Entry<K, V>(key, this.fetcher.apply(key), now);
            this.values.put(key, entry);
            this.generations[0].entries.add(entry);
        } else {
            entry.lastAccess = now;
        }
        this.doCleanup(now);
        return entry.value;
    }

    public final void doCleanup() {
        this.doCleanup(System.nanoTime());
    }

    private void doCleanup(long now) {
        if (this.values.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.generations.length; ++i) {
            Generation<K, V> generation = this.generations[i];
            if (generation.entries.isEmpty()) {
                generation.lastCleanup = now;
                continue;
            }
            if (now - generation.lastCleanup <= generation.expiration) continue;
            generation.lastCleanup = now;
            Generation<K, V> nextGeneration = i < this.generations.length - 1 ? this.generations[i + 1] : null;
            Iterator iterator = generation.entries.iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (now - entry.lastAccess > generation.expiration) {
                    iterator.remove();
                    this.values.remove(entry.key);
                    if (this.release == null) continue;
                    this.release.accept(entry.key, entry.value);
                    continue;
                }
                if (nextGeneration == null) continue;
                iterator.remove();
                nextGeneration.entries.add(entry);
            }
        }
    }

    public final void clear() {
        this.values.clear();
        for (Generation<K, V> generation : this.generations) {
            generation.entries.clear();
        }
    }

    private static class Generation<K, V> {
        public final long expiration;
        public final ObjectOpenHashSet<Entry<K, V>> entries = new ObjectOpenHashSet();
        public long lastCleanup;

        public Generation(long expiration) {
            this.expiration = expiration;
        }
    }

    private static class Entry<K, V> {
        public final K key;
        public final int keyHash;
        public final V value;
        public long lastAccess;

        public Entry(K key, V value, long lastAccess) {
            this.key = key;
            this.keyHash = key.hashCode();
            this.value = value;
            this.lastAccess = lastAccess;
        }

        public int hashCode() {
            return this.keyHash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)obj;
            return this.key.equals(e.key);
        }
    }
}

