/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.blockstate.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockPropertyTrait;
import com.gtnewhorizon.gtnhlib.blockstate.core.InvalidPropertyTextException;
import com.gtnewhorizon.gtnhlib.blockstate.core.MetaBlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.TransformableProperty;
import com.gtnewhorizon.gtnhlib.geometry.Axis;
import com.gtnewhorizon.gtnhlib.geometry.DirectionTransform;
import java.lang.reflect.Type;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public interface AxisBlockProperty
extends BlockProperty<Axis>,
TransformableProperty<Axis> {
    @Override
    default public String getName() {
        return "axis";
    }

    @Override
    default public Type getType() {
        return Axis.class;
    }

    @Override
    default public JsonElement serialize(Axis value) {
        return new JsonPrimitive(this.stringify(value));
    }

    @Override
    default public Axis deserialize(JsonElement element) {
        return element.isJsonPrimitive() && element.getAsJsonPrimitive().isString() ? this.parse(element.getAsString()) : Axis.UNKNOWN;
    }

    @Override
    default public String stringify(Axis value) {
        return value.name().toLowerCase();
    }

    @Override
    default public Axis parse(String text) throws InvalidPropertyTextException {
        try {
            return Axis.valueOf(text.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidPropertyTextException("Invalid Axis", e);
        }
    }

    default public boolean isValidAxis(Axis value) {
        return true;
    }

    @Override
    @NotNull
    default public Axis transform(Axis value, DirectionTransform transform) {
        Axis axis = Axis.fromDirection((ForgeDirection)transform.apply(value.positive()));
        return this.isValidAxis(axis) ? axis : value;
    }

    public static AbstractAxisBlockProperty axis(final int mask, final A2M toMeta, final M2A toAxis) {
        return new AbstractAxisBlockProperty("axis"){

            @Override
            public boolean needsExisting() {
                return mask != -1;
            }

            @Override
            public int getMeta(Axis value, int existing) {
                return toMeta.getMeta(value) | existing & ~mask;
            }

            @Override
            public Axis getValue(int meta) {
                return toAxis.getAxis(meta & mask);
            }
        };
    }

    public static interface A2M {
        public int getMeta(Axis var1);
    }

    public static interface M2A {
        public Axis getAxis(int var1);
    }

    public static abstract class AbstractAxisBlockProperty
    implements Meta {
        private final String name;

        public AbstractAxisBlockProperty(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean hasTrait(BlockPropertyTrait trait) {
            boolean bl;
            switch (trait) {
                case SupportsWorld: 
                case WorldMutable: 
                case OnlyNeedsMeta: 
                case Config: 
                case Transformable: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
    }

    public static interface Meta
    extends AxisBlockProperty,
    MetaBlockProperty<Axis> {
        @Override
        default public boolean appliesTo(int meta) {
            return this.isValidAxis((Axis)((Object)this.getValue(meta)));
        }
    }
}

