/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.blockstate.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockPropertyTrait;
import com.gtnewhorizon.gtnhlib.blockstate.core.InvalidPropertyTextException;
import com.gtnewhorizon.gtnhlib.blockstate.core.MetaBlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.TransformableProperty;
import com.gtnewhorizon.gtnhlib.geometry.DirectionTransform;
import java.lang.reflect.Type;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public interface DirectionBlockProperty
extends BlockProperty<ForgeDirection>,
TransformableProperty<ForgeDirection> {
    @Override
    default public String getName() {
        return "direction";
    }

    @Override
    default public Type getType() {
        return ForgeDirection.class;
    }

    @Override
    @NotNull
    default public ForgeDirection transform(ForgeDirection value, DirectionTransform transform) {
        ForgeDirection dir = (ForgeDirection)transform.apply(value);
        return this.isValidDirection(dir) ? dir : value;
    }

    @Override
    default public JsonElement serialize(ForgeDirection value) {
        return new JsonPrimitive(this.stringify(value));
    }

    @Override
    default public ForgeDirection deserialize(JsonElement element) {
        return element.isJsonPrimitive() && element.getAsJsonPrimitive().isString() ? this.parse(element.getAsString()) : ForgeDirection.UNKNOWN;
    }

    @Override
    default public String stringify(ForgeDirection value) {
        return value.name().toLowerCase();
    }

    @Override
    default public ForgeDirection parse(String text) throws InvalidPropertyTextException {
        try {
            return ForgeDirection.valueOf((String)text.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidPropertyTextException("Invalid ForgeDirection", e);
        }
    }

    default public boolean isValidDirection(ForgeDirection value) {
        return true;
    }

    public static DirectionBlockProperty facing() {
        return new AbstractDirectionBlockProperty("facing"){

            @Override
            public int getMeta(ForgeDirection value, int existing) {
                return value.ordinal();
            }

            @Override
            public ForgeDirection getValue(int meta) {
                return ForgeDirection.getOrientation((int)meta);
            }
        };
    }

    public static AbstractDirectionBlockProperty facingVanilla(int mask) {
        return DirectionBlockProperty.facing(mask, dir -> {
            int n;
            switch (dir) {
                case NORTH: {
                    n = 3;
                    break;
                }
                case SOUTH: {
                    n = 4;
                    break;
                }
                case WEST: {
                    n = 1;
                    break;
                }
                case EAST: {
                    n = 2;
                    break;
                }
                case UP: {
                    n = 0;
                    break;
                }
                case DOWN: {
                    n = 5;
                    break;
                }
                default: {
                    n = 3;
                }
            }
            return n;
        }, meta -> {
            ForgeDirection forgeDirection;
            switch (meta) {
                case 3: {
                    forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                case 4: {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                case 1: {
                    forgeDirection = ForgeDirection.WEST;
                    break;
                }
                case 2: {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case 0: {
                    forgeDirection = ForgeDirection.UP;
                    break;
                }
                case 5: {
                    forgeDirection = ForgeDirection.DOWN;
                    break;
                }
                default: {
                    forgeDirection = ForgeDirection.NORTH;
                }
            }
            return forgeDirection;
        });
    }

    public static AbstractDirectionBlockProperty facing(final int mask, final D2M toMeta, final M2D toDir) {
        return new AbstractDirectionBlockProperty("facing"){

            @Override
            public boolean needsExisting() {
                return mask != -1;
            }

            @Override
            public int getMeta(ForgeDirection value, int existing) {
                return toMeta.getMeta(value) | existing & ~mask;
            }

            @Override
            public ForgeDirection getValue(int meta) {
                return toDir.getDir(meta & mask);
            }
        };
    }

    public static AbstractDirectionBlockProperty facing(final D2M2 toMeta, final M2D toDir) {
        return new AbstractDirectionBlockProperty("facing"){

            @Override
            public int getMeta(ForgeDirection value, int existing) {
                return toMeta.getMeta(value, existing);
            }

            @Override
            public ForgeDirection getValue(int meta) {
                return toDir.getDir(meta);
            }
        };
    }

    public static AbstractDirectionBlockProperty facing(int mask, int north, int south, int west, int east, int up, int down) {
        return DirectionBlockProperty.facing(mask, dir -> {
            int n;
            switch (dir) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NORTH: {
                    if (north == -1) {
                        n = 0;
                        break;
                    }
                    n = north;
                    break;
                }
                case SOUTH: {
                    if (south == -1) {
                        n = 0;
                        break;
                    }
                    n = south;
                    break;
                }
                case WEST: {
                    if (west == -1) {
                        n = 0;
                        break;
                    }
                    n = west;
                    break;
                }
                case EAST: {
                    if (east == -1) {
                        n = 0;
                        break;
                    }
                    n = east;
                    break;
                }
                case UP: {
                    if (up == -1) {
                        n = 0;
                        break;
                    }
                    n = up;
                    break;
                }
                case DOWN: {
                    if (down == -1) {
                        n = 0;
                        break;
                    }
                    n = down;
                    break;
                }
                case UNKNOWN: {
                    n = 0;
                }
            }
            return n;
        }, meta -> {
            if (meta == north) {
                return ForgeDirection.NORTH;
            }
            if (meta == south) {
                return ForgeDirection.SOUTH;
            }
            if (meta == west) {
                return ForgeDirection.WEST;
            }
            if (meta == east) {
                return ForgeDirection.EAST;
            }
            if (meta == up) {
                return ForgeDirection.UP;
            }
            if (meta == down) {
                return ForgeDirection.DOWN;
            }
            return ForgeDirection.UNKNOWN;
        });
    }

    public static interface D2M {
        public int getMeta(ForgeDirection var1);
    }

    public static interface M2D {
        public ForgeDirection getDir(int var1);
    }

    public static abstract class AbstractDirectionBlockProperty
    implements DirectionBlockProperty,
    MetaBlockProperty<ForgeDirection> {
        private String name;

        public AbstractDirectionBlockProperty(String name) {
            this.name = name;
        }

        public AbstractDirectionBlockProperty setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean hasTrait(BlockPropertyTrait trait) {
            boolean bl;
            switch (trait) {
                case SupportsWorld: 
                case WorldMutable: 
                case OnlyNeedsMeta: 
                case Config: 
                case Transformable: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
    }

    public static interface D2M2 {
        public int getMeta(ForgeDirection var1, int var2);
    }
}

