/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.shader;

import com.gtnewhorizon.gtnhlib.client.renderer.shader.IShaderReloadRunnable;
import com.gtnewhorizon.gtnhlib.client.renderer.shader.ShaderProgram;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;

public class AutoShaderUpdater {
    private static AutoShaderUpdater instance;
    private WatchService watchService;
    private final List<ListeningShader> listeningShaders = new ArrayList<ListeningShader>();
    private final Set<Path> watchedPaths = new HashSet<Path>();

    public static AutoShaderUpdater getInstance() {
        if (instance == null) {
            instance = new AutoShaderUpdater();
        }
        return instance;
    }

    private AutoShaderUpdater() {
        if (Launch.blackboard == null || !((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            throw new UnsupportedOperationException("Cannot use AutoShaderUpdate in an obfuscated environment! This is an oversight by the developer!");
        }
    }

    public void registerShaderReload(ShaderProgram program, ResourceLocation vertexShader, ResourceLocation fragmentShader) {
        this.registerShaderReload(program, vertexShader, fragmentShader, null);
    }

    public void registerShaderReload(ShaderProgram program, ResourceLocation vertexShader, ResourceLocation fragmentShader, IShaderReloadRunnable runnable) {
        if (!vertexShader.getResourceDomain().equals(fragmentShader.getResourceDomain())) {
            throw new IllegalArgumentException("The directory of vertex and fragment shader must match!");
        }
        this.registerShaderReload(program, vertexShader.getResourceDomain(), vertexShader.getResourcePath(), fragmentShader.getResourcePath(), runnable);
    }

    public void registerShaderReload(ShaderProgram program, String domain, String vertShaderFilename, String fragShaderFilename) {
        this.registerShaderReload(program, domain, vertShaderFilename, fragShaderFilename, null);
    }

    public void registerShaderReload(ShaderProgram program, String domain, String vertShaderFilename, String fragShaderFilename, IShaderReloadRunnable runnable) {
        try {
            if (this.watchService == null) {
                this.watchService = FileSystems.getDefault().newWatchService();
                this.startWatchServiceListener();
            }
            Path vertexPath = AutoShaderUpdater.getShaderPath(domain, vertShaderFilename);
            Path fragmentPath = AutoShaderUpdater.getShaderPath(domain, fragShaderFilename);
            Path parent = vertexPath.getParent();
            if (!Files.exists(vertexPath, new LinkOption[0])) {
                throw new RuntimeException("Vertex shader " + vertShaderFilename + " not found! Path: " + vertexPath);
            }
            if (!Files.exists(fragmentPath, new LinkOption[0])) {
                throw new RuntimeException("Fragment shader " + fragShaderFilename + " not found! Path: " + fragmentPath);
            }
            if (!this.watchedPaths.contains(parent)) {
                parent.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                System.out.println("Listening for shader changes in " + parent);
                this.watchedPaths.add(parent);
            }
            this.listeningShaders.add(new ListeningShader(program, vertShaderFilename, fragShaderFilename, vertexPath, fragmentPath, runnable));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Path getShaderPath(String domain, String path) {
        return Paths.get(new File("../../src/main/resources/assets/" + domain + "/" + path).getAbsolutePath(), new String[0]);
    }

    private void startWatchServiceListener() {
        Thread thread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        WatchKey key = this.watchService.take();
                        for (WatchEvent<?> event : key.pollEvents()) {
                            String file = event.context().toString();
                            for (ListeningShader shader : this.listeningShaders) {
                                if (!shader.fragmentPath.getFileName().toString().equals(file) && !shader.vertexPath.getFileName().toString().equals(file)) continue;
                                System.out.println("Shader " + file + " changed, recompiling...");
                                Minecraft.getMinecraft().func_152344_a((Runnable)shader);
                            }
                        }
                        key.reset();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }, "ShaderUpdateWatcher");
        thread.setDaemon(true);
        thread.start();
    }

    private static class ListeningShader
    implements Runnable {
        private final ShaderProgram shader;
        private final String rawVertexPath;
        private final String rawFragmentPath;
        private final Path fragmentPath;
        private final Path vertexPath;
        private final IShaderReloadRunnable runnable;

        public ListeningShader(ShaderProgram shader, String rawVertexPath, String rawFragmentPath, Path vertexPath, Path fragmentPath, IShaderReloadRunnable runnable) {
            this.shader = shader;
            this.rawVertexPath = rawVertexPath;
            this.rawFragmentPath = rawFragmentPath;
            this.vertexPath = vertexPath;
            this.fragmentPath = fragmentPath;
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.shader.close();
                this.shader.reload(this.vertexPath, this.fragmentPath);
                if (this.runnable != null) {
                    this.shader.use();
                    this.runnable.run(this.shader, this.vertexPath, this.fragmentPath);
                    ShaderProgram.clear();
                }
                Minecraft.getMinecraft().thePlayer.addChatMessage((IChatComponent)new ChatComponentText("Updated Shaders " + this.rawVertexPath + " and " + this.rawFragmentPath));
            }
            catch (Exception e) {
                e.printStackTrace();
                Minecraft.getMinecraft().thePlayer.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Failed to update " + this.rawVertexPath + " or " + this.rawFragmentPath + ". See logs for more info."));
            }
        }
    }
}

