/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.textures;

import com.gtnewhorizon.gtnhlib.client.renderer.textures.SpriteAnimationMetadata;
import com.gtnewhorizon.gtnhlib.client.renderer.textures.TextureLoader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class AnimatedTexture {
    private final SpriteAnimationMetadata metadata;
    public final int texture;
    private final float heightUnit;
    private int lastTextureUpdate;

    public AnimatedTexture(ResourceLocation resourceLocation) {
        IResourceManager resourceManager = Minecraft.getMinecraft().getResourceManager();
        try {
            IResource resource = resourceManager.getResource(resourceLocation);
            BufferedImage image = TextureLoader.getBufferedImage(resource);
            this.metadata = new SpriteAnimationMetadata(resource, image);
            this.texture = TextureLoader.createBindTexture(6408, 32993, image);
            this.heightUnit = 1.0f / (float)(image.getHeight() / image.getWidth());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void checkUpdateTexture() {
        if (this.lastTextureUpdate != Minecraft.getMinecraft().thePlayer.ticksExisted) {
            this.lastTextureUpdate = Minecraft.getMinecraft().thePlayer.ticksExisted;
            this.metadata.updateAnimation();
        }
    }

    public final void bindTexture() {
        GL11.glBindTexture((int)3553, (int)this.texture);
    }

    public final float getMinU() {
        return 0.0f;
    }

    public final float getMaxU() {
        return 1.0f;
    }

    public final float getMinV() {
        this.checkUpdateTexture();
        return (float)this.metadata.index * this.heightUnit;
    }

    public final float getMaxV() {
        this.checkUpdateTexture();
        return (float)(this.metadata.index + 1) * this.heightUnit;
    }
}

