/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.textures;

import com.google.common.annotations.Beta;
import com.gtnewhorizon.gtnhlib.core.GTNHLibCore;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import org.lwjgl.opengl.GL11;

@Beta
public class TextureLoader {
    public static final IntBuffer dataBuffer;

    public static BufferedImage getBufferedImage(IResource resource) throws IOException {
        InputStream inputStream = resource.getInputStream();
        BufferedImage image = ImageIO.read(inputStream);
        inputStream.close();
        return image;
    }

    public static int[] mergeImages(BufferedImage[] images, int totalWidth, int maxHeight) {
        int amount = images.length;
        int[] atlasRGB = new int[totalWidth * maxHeight];
        int maxWidth = 0;
        for (BufferedImage image : images) {
            if (image.getWidth() <= maxWidth) continue;
            maxWidth = image.getWidth();
        }
        int[] rgb = new int[maxWidth * maxHeight];
        for (int i = 0; i < amount; ++i) {
            BufferedImage texture = images[i];
            int width = texture.getWidth();
            int height = texture.getHeight();
            texture.getRGB(0, 0, width, height, rgb, 0, width);
            for (int y = 0; y < height; ++y) {
                int src = y * width;
                int dest = y * totalWidth + i * width;
                System.arraycopy(rgb, src, atlasRGB, dest, width);
            }
        }
        return atlasRGB;
    }

    public static int[] getImagePixels(BufferedImage image) {
        int[] pixels = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        return pixels;
    }

    public static int createBindTexture(BufferedImage image) {
        return TextureLoader.createBindTexture(6408, 32993, image);
    }

    public static int createBindTexture(int format, BufferedImage image) {
        return TextureLoader.createBindTexture(format, 32993, image);
    }

    public static int createBindTexture(int format, int pixelFormat, BufferedImage image) {
        return TextureLoader.createBindTexture(format, pixelFormat, image.getWidth(), image.getHeight(), TextureLoader.getImagePixels(image));
    }

    public static int createBindTextureAtlas(int atlasWidth, int atlasHeight, BufferedImage[] images) {
        return TextureLoader.createBindTextureAtlas(6408, 32993, atlasWidth, atlasHeight, images);
    }

    public static int createBindTextureAtlas(int format, int pixelFormat, int atlasWidth, int atlasHeight, BufferedImage[] images) {
        return TextureLoader.createBindTexture(format, pixelFormat, atlasWidth, atlasHeight, TextureLoader.mergeImages(images, atlasWidth, atlasHeight));
    }

    public static int createBindTexture(int format, int pixelFormat, int width, int height, int[] pixels) {
        return TextureLoader.createBindTexture(format, pixelFormat, width, height, pixels, 9728);
    }

    public static int createBindTexture(int format, int pixelFormat, int width, int height, int[] pixels, int filter) {
        dataBuffer.clear();
        dataBuffer.put(pixels).flip();
        int texture = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)texture);
        GL11.glTexImage2D((int)3553, (int)0, (int)format, (int)width, (int)height, (int)0, (int)pixelFormat, (int)33639, (IntBuffer)dataBuffer);
        GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
        return texture;
    }

    static {
        IntBuffer buffer;
        try {
            Field f = TextureUtil.class.getDeclaredField(GTNHLibCore.isObf() ? "field_111000_c" : "dataBuffer");
            f.setAccessible(true);
            buffer = (IntBuffer)f.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            buffer = GLAllocation.createDirectIntBuffer((int)0x400000);
        }
        dataBuffer = buffer;
    }
}

