/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.eventbus;

import com.gtnewhorizon.gtnhlib.eventbus.EventBusUtil;
import com.gtnewhorizon.gtnhlib.eventbus.MethodInfo;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.IEventListener;
import java.lang.reflect.Method;
import lombok.Generated;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class StaticASMEventHandler
implements IEventListener {
    private static int IDs = 0;
    private static final String HANDLER_DESC = Type.getInternalName(IEventListener.class);
    private static final String HANDLER_FUNC_DESC = Type.getMethodDescriptor((Method)IEventListener.class.getDeclaredMethods()[0]);
    private static final ASMClassLoader LOADER = new ASMClassLoader();
    private final IEventListener handler;
    private final String readable;
    private final boolean receiveCanceled;
    private final EventPriority priority;

    StaticASMEventHandler(MethodInfo method) throws Exception {
        this.handler = (IEventListener)this.createWrapper(method).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.readable = "ASM: " + method.getDeclaringClass() + " " + method.getName() + method.getDesc();
        this.receiveCanceled = method.receiveCanceled;
        this.priority = method.getPriority();
    }

    public void invoke(Event event) {
        if (this.handler == null) {
            return;
        }
        if (!event.isCancelable() || !event.isCanceled() || this.receiveCanceled) {
            this.handler.invoke(event);
        }
    }

    public Class<?> createWrapper(MethodInfo method) {
        ClassWriter cw = new ClassWriter(0);
        String name = this.getUniqueName(method);
        String desc = name.replace('.', '/');
        String instType = method.getDeclaringClass().replace('.', '/');
        String eventType = EventBusUtil.getParameterClassInternal(method.getDesc());
        cw.visit(50, 33, desc, null, "java/lang/Object", new String[]{HANDLER_DESC});
        cw.visitSource(".dynamic", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "invoke", HANDLER_FUNC_DESC, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, eventType);
        mv.visitMethodInsn(184, instType, method.name, method.desc, false);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        cw.visitEnd();
        return LOADER.define(name, cw.toByteArray());
    }

    private String getUniqueName(MethodInfo method) {
        String param = EventBusUtil.getParameterClassName(method.getDesc());
        String declaring = method.getDeclaringClass();
        return String.format("%s_%d_%s_%s_%s", this.getClass().getName(), IDs++, EventBusUtil.getSimpleClassName(declaring), method.getName(), EventBusUtil.getSimpleClassName(param));
    }

    public String toString() {
        return this.readable;
    }

    @Generated
    public EventPriority getPriority() {
        return this.priority;
    }

    private static class ASMClassLoader
    extends ClassLoader {
        private ASMClassLoader() {
            super(ASMClassLoader.class.getClassLoader());
        }

        public Class<?> define(String name, byte[] data) {
            return this.defineClass(name, data, 0, data.length);
        }
    }
}

