/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderUtil {
    public static void renderItem(IItemRenderer.ItemRenderType type, IIcon icon) {
        Tessellator tess = Tessellator.instance;
        float maxU = icon.getMaxU();
        float minV = icon.getMinV();
        float minU = icon.getMinU();
        float maxV = icon.getMaxV();
        switch (type) {
            case ENTITY: {
                if (Minecraft.getMinecraft().gameSettings.fancyGraphics) {
                    ItemRenderer.renderItemIn2D((Tessellator)tess, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
                    break;
                }
                GL11.glPushMatrix();
                if (!RenderItem.renderInFrame) {
                    GL11.glRotatef((float)(180.0f - RenderManager.instance.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                tess.startDrawingQuads();
                tess.setNormal(0.0f, 1.0f, 0.0f);
                tess.addVertexWithUV(-0.5, -0.25, 0.0, (double)minU, (double)maxV);
                tess.addVertexWithUV(0.5, -0.25, 0.0, (double)maxU, (double)maxV);
                tess.addVertexWithUV(0.5, 0.75, 0.0, (double)maxU, (double)minV);
                tess.addVertexWithUV(-0.5, 0.75, 0.0, (double)minU, (double)minV);
                tess.draw();
                GL11.glPopMatrix();
                break;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                ItemRenderer.renderItemIn2D((Tessellator)tess, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
                break;
            }
            case INVENTORY: {
                ItemRenderUtil.renderItemIcon(icon, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
                break;
            }
        }
    }

    public static void renderItemIcon(IIcon icon, double size, double z, float nx, float ny, float nz) {
        ItemRenderUtil.renderItemIcon(icon, 0.0, 0.0, size, size, z, nx, ny, nz);
    }

    public static void renderItemIcon(IIcon icon, double xStart, double yStart, double xEnd, double yEnd, double z, float nx, float ny, float nz) {
        if (icon == null) {
            return;
        }
        Tessellator tess = Tessellator.instance;
        tess.startDrawingQuads();
        tess.setNormal(nx, ny, nz);
        if (nz > 0.0f) {
            tess.addVertexWithUV(xStart, yStart, z, (double)icon.getMinU(), (double)icon.getMinV());
            tess.addVertexWithUV(xEnd, yStart, z, (double)icon.getMaxU(), (double)icon.getMinV());
            tess.addVertexWithUV(xEnd, yEnd, z, (double)icon.getMaxU(), (double)icon.getMaxV());
            tess.addVertexWithUV(xStart, yEnd, z, (double)icon.getMinU(), (double)icon.getMaxV());
        } else {
            tess.addVertexWithUV(xStart, yEnd, z, (double)icon.getMinU(), (double)icon.getMaxV());
            tess.addVertexWithUV(xEnd, yEnd, z, (double)icon.getMaxU(), (double)icon.getMaxV());
            tess.addVertexWithUV(xEnd, yStart, z, (double)icon.getMaxU(), (double)icon.getMinV());
            tess.addVertexWithUV(xStart, yStart, z, (double)icon.getMinU(), (double)icon.getMinV());
        }
        tess.draw();
    }

    public static void applyStandardItemTransform(IItemRenderer.ItemRenderType type) {
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            if (RenderItem.renderInFrame) {
                GL11.glScalef((float)1.025641f, (float)1.025641f, (float)1.025641f);
                GL11.glTranslatef((float)0.0f, (float)-0.05f, (float)0.0f);
            }
            if (Minecraft.getMinecraft().gameSettings.fancyGraphics) {
                if (RenderItem.renderInFrame) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)0.0421875f);
            }
        }
    }

    public static void undoStandardItemTransform(IItemRenderer.ItemRenderType type) {
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            if (Minecraft.getMinecraft().gameSettings.fancyGraphics) {
                GL11.glTranslatef((float)0.5f, (float)0.25f, (float)-0.0421875f);
                if (RenderItem.renderInFrame) {
                    GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            if (RenderItem.renderInFrame) {
                GL11.glTranslatef((float)0.0f, (float)0.05f, (float)0.0f);
                GL11.glScalef((float)0.9750001f, (float)0.9750001f, (float)0.9750001f);
            }
        }
    }
}

