/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util.data;

import com.gtnewhorizon.gtnhlib.util.data.ImmutableItemMeta;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemMeta
implements ImmutableItemMeta {
    @Nonnull
    private Item item;
    private int meta;

    public ItemMeta(@Nonnull Item item, int meta) {
        this.item = item;
        this.meta = meta;
    }

    public ItemMeta(@Nonnull Item item) {
        this(item, 0);
    }

    public ItemMeta(ImmutableItemMeta im) {
        this(im.getItem(), im.getItemMeta());
    }

    public ItemMeta(ItemStack stack) {
        this(Objects.requireNonNull(stack.getItem(), "Item must not be null"), Items.feather.getDamage(stack));
    }

    @Override
    @Nonnull
    public Item getItem() {
        return this.item;
    }

    @Override
    public int getItemMeta() {
        return this.meta;
    }

    public ItemMeta setItem(@Nonnull Item item) {
        this.item = Objects.requireNonNull(item);
        return this;
    }

    public ItemMeta setItemMeta(int meta) {
        this.meta = meta;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.item.hashCode();
        result = 31 * result + this.meta;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemMeta other = (ItemMeta)obj;
        if (!this.item.equals(other.item)) {
            return false;
        }
        return this.meta == other.meta;
    }

    public String toString() {
        return "ItemMeta [item=" + this.item + ", meta=" + this.meta + "]";
    }
}

