/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.monikamod.events;

import com.yourname.monikamod.entities.MonikaEntity;
import com.yourname.monikamod.init.ItemInit;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="monikamod")
public class EventHandlers {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().f_46443_) {
            return;
        }
        EventHandlers.ensureKeepInventory(player);
        boolean isMonikaNearby = EventHandlers.isMonikaNearby(player);
        if (isMonikaNearby && !EventHandlers.hasMonikaMark(player)) {
            ItemStack monikaMark = new ItemStack((ItemLike)ItemInit.MONIKA_MARK.get());
            monikaMark.m_41663_(Enchantments.f_44975_, 1);
            player.m_150109_().f_35975_.set(3, (Object)monikaMark);
            player.getPersistentData().m_128379_("monika_hypnosis", true);
            player.m_213846_((Component)Component.m_237113_((String)"Just Monika... Forever."));
        }
        if (EventHandlers.hasMonikaMark(player)) {
            EventHandlers.activateHypnosis(player, isMonikaNearby);
            EventHandlers.ensureCurseBinding(player);
            EventHandlers.ensureMarkNeverLost(player);
        } else {
            player.getPersistentData().m_128379_("monika_hypnosis", false);
        }
    }

    private static void ensureKeepInventory(Player player) {
        ServerLevel serverLevel;
        Level level;
        if (player.getPersistentData().m_128471_("keepInventory") && (level = player.m_9236_()) instanceof ServerLevel && !(serverLevel = (ServerLevel)level).m_46469_().m_46207_(GameRules.f_46133_)) {
            ((GameRules.BooleanValue)serverLevel.m_46469_().m_46170_(GameRules.f_46133_)).m_46246_(true, serverLevel.m_7654_());
        }
    }

    private static void ensureMarkNeverLost(Player player) {
        if (!EventHandlers.hasMonikaMark(player)) {
            ItemStack monikaMark = new ItemStack((ItemLike)ItemInit.MONIKA_MARK.get());
            monikaMark.m_41663_(Enchantments.f_44975_, 1);
            player.m_150109_().f_35975_.set(3, (Object)monikaMark);
        }
    }

    private static void ensureCurseBinding(Player player) {
        ItemStack helmet = (ItemStack)player.m_150109_().f_35975_.get(3);
        if (!helmet.m_41619_() && helmet.m_41720_() == ItemInit.MONIKA_MARK.get() && helmet.m_41785_().isEmpty()) {
            helmet.m_41663_(Enchantments.f_44975_, 1);
        }
    }

    private static boolean isMonikaNearby(Player player) {
        List monikas = player.m_9236_().m_45976_(MonikaEntity.class, new AABB(player.m_20183_()).m_82400_(5.0));
        return !monikas.isEmpty();
    }

    private static boolean hasMonikaMark(Player player) {
        ItemStack helmet = (ItemStack)player.m_150109_().f_35975_.get(3);
        return !helmet.m_41619_() && helmet.m_41720_() == ItemInit.MONIKA_MARK.get();
    }

    private static void activateHypnosis(Player player, boolean isMonikaNearby) {
        player.getPersistentData().m_128379_("monika_hypnosis", true);
        if (isMonikaNearby) {
            EventHandlers.limitMovement(player);
        }
        EventHandlers.replaceSolidBlocksWithWool(player);
    }

    private static void limitMovement(Player player) {
        List monikas = player.m_9236_().m_45976_(MonikaEntity.class, new AABB(player.m_20183_()).m_82400_(10.0));
        if (!monikas.isEmpty()) {
            MonikaEntity monika = (MonikaEntity)((Object)monikas.get(0));
            double dx = monika.m_20185_() - player.m_20185_();
            double dy = monika.m_20188_() - player.m_20188_();
            double dz = monika.m_20189_() - player.m_20189_();
            double dist = Math.sqrt(dx * dx + dz * dz);
            float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float pitch = (float)(-(Math.atan2(dy, dist) * 180.0 / Math.PI));
            player.m_146922_(yaw);
            player.m_146926_(pitch);
            player.f_19859_ = yaw;
            player.f_19860_ = pitch;
            player.m_20256_(player.m_20184_().m_82542_(0.5, 1.0, 0.5));
        }
    }

    private static void replaceSolidBlocksWithWool(Player player) {
        List<Block> blacklistedBlocks = List.of(Blocks.f_50016_, Blocks.f_50627_, Blocks.f_50626_, Blocks.f_49990_, Blocks.f_49991_, Blocks.f_50083_, Blocks.f_50084_, Blocks.f_50100_, Blocks.f_50034_, Blocks.f_50359_, Blocks.f_50035_, Blocks.f_50360_, Blocks.f_50036_, Blocks.f_50191_, Blocks.f_50196_, Blocks.f_50037_, Blocks.f_50038_, Blocks.f_50575_, Blocks.f_50576_, Blocks.f_50125_, Blocks.f_50127_, Blocks.f_50126_, Blocks.f_50354_, Blocks.f_50568_, Blocks.f_50449_, Blocks.f_50081_, Blocks.f_50082_, Blocks.f_50681_, Blocks.f_50682_, Blocks.f_152482_, Blocks.f_50567_, Blocks.f_152475_);
        BlockPos.m_121990_((BlockPos)player.m_20183_().m_7918_(-3, -1, -3), (BlockPos)player.m_20183_().m_7918_(3, 1, 3)).forEach(pos -> {
            boolean shouldNotReplace;
            BlockState blockState = player.m_9236_().m_8055_(pos);
            Block block = blockState.m_60734_();
            boolean bl = shouldNotReplace = blacklistedBlocks.contains(block) || blockState.m_60795_() || !blockState.m_60815_() || !blockState.m_280296_() || blockState.m_60734_() instanceof FlowerBlock || blockState.m_60734_() instanceof BushBlock || blockState.m_60734_() instanceof SaplingBlock;
            if (!shouldNotReplace) {
                player.m_9236_().m_7731_(pos, Blocks.f_50100_.m_49966_(), 3);
            }
        });
    }
}

