/*
 * Decompiled with CFR 0.152.
 */
package pl.nubet.debugstickinsurvival.config;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigurationManager {
    private final JavaPlugin plugin;
    private FileConfiguration config;
    private Set<Material> excludedBlocks;
    private String restrictionMessage;
    private String waterlogRestrictionMessage;
    private String slabDoublingRestrictionMessage;
    private boolean enableCrafting;
    private boolean enableRestrictions;
    private boolean enableCapabilityRestrictions;
    private boolean enableWaterloggingRestriction;
    private boolean enableSlabDoublingRestriction;

    public ConfigurationManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.excludedBlocks = new HashSet<Material>();
    }

    public void loadConfiguration() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.loadExcludedBlocks();
        this.loadMessages();
        this.loadFeatureToggles();
        this.plugin.getLogger().info("Configuration loaded successfully. Excluded blocks: " + this.excludedBlocks.size());
    }

    private void loadExcludedBlocks() {
        List blockNames = this.config.getStringList("excluded_blocks");
        this.excludedBlocks = blockNames.stream().map(this::parseMaterial).filter(material -> material != null).collect(Collectors.toSet());
    }

    private Material parseMaterial(String materialName) {
        try {
            return Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().log(Level.WARNING, "Invalid material in config: " + materialName + ". Skipping...");
            return null;
        }
    }

    private void loadMessages() {
        this.restrictionMessage = this.config.getString("messages.restriction", "\u00a7cYou cannot use the Debug Stick on this type of block!");
        this.waterlogRestrictionMessage = this.config.getString("messages.waterlog_restriction", "\u00a7cYou don't have permission to waterlog blocks with the Debug Stick!");
        this.slabDoublingRestrictionMessage = this.config.getString("messages.slab_doubling_restriction", "\u00a7cYou don't have permission to create double slabs with the Debug Stick!");
    }

    private void loadFeatureToggles() {
        this.enableCrafting = this.config.getBoolean("features.enable_crafting", true);
        this.enableRestrictions = this.config.getBoolean("features.enable_restrictions", true);
        this.enableCapabilityRestrictions = this.config.getBoolean("features.enable_capability_restrictions", true);
        this.enableWaterloggingRestriction = this.config.getBoolean("features.restrict_waterlogging", true);
        this.enableSlabDoublingRestriction = this.config.getBoolean("features.restrict_slab_doubling", true);
    }

    public Set<Material> getExcludedBlocks() {
        return new HashSet<Material>(this.excludedBlocks);
    }

    public String getRestrictionMessage() {
        return this.restrictionMessage;
    }

    public String getWaterlogRestrictionMessage() {
        return this.waterlogRestrictionMessage;
    }

    public String getSlabDoublingRestrictionMessage() {
        return this.slabDoublingRestrictionMessage;
    }

    public boolean isCraftingEnabled() {
        return this.enableCrafting;
    }

    public boolean areRestrictionsEnabled() {
        return this.enableRestrictions;
    }

    public boolean areCapabilityRestrictionsEnabled() {
        return this.enableCapabilityRestrictions;
    }

    public boolean isWaterloggingRestrictionEnabled() {
        return this.enableWaterloggingRestriction;
    }

    public boolean isSlabDoublingRestrictionEnabled() {
        return this.enableSlabDoublingRestriction;
    }

    public void reload() {
        this.loadConfiguration();
    }
}

