/*
 * Decompiled with CFR 0.152.
 */
package pl.nubet.debugstickinsurvival;

import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import pl.nubet.debugstickinsurvival.command.ReloadCommand;
import pl.nubet.debugstickinsurvival.config.ConfigurationManager;
import pl.nubet.debugstickinsurvival.listener.DebugStickInteractionListener;
import pl.nubet.debugstickinsurvival.recipe.DebugStickRecipeManager;
import pl.nubet.debugstickinsurvival.service.BlockRestrictionService;
import pl.nubet.debugstickinsurvival.service.DebugStickCapabilityService;

public final class DebugStickCraftingInSurvival
extends JavaPlugin {
    private ConfigurationManager configurationManager;
    private BlockRestrictionService blockRestrictionService;
    private DebugStickCapabilityService capabilityService;
    private DebugStickRecipeManager recipeManager;

    public void onEnable() {
        try {
            this.initializePlugin();
            this.getLogger().info("DebugStickCraftingInSurvival v" + this.getDescription().getVersion() + " has been enabled!");
            this.getLogger().info("Running on Minecraft " + this.getServer().getVersion());
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to enable DebugStickCraftingInSurvival", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        this.unregisterRecipes();
        this.getLogger().info("DebugStickCraftingInSurvival has been disabled.");
    }

    private void initializePlugin() {
        this.loadConfiguration();
        this.initializeServices();
        this.registerRecipes();
        this.registerEventListeners();
        this.registerCommands();
    }

    private void loadConfiguration() {
        this.saveDefaultConfig();
        this.configurationManager = new ConfigurationManager(this);
        this.configurationManager.loadConfiguration();
    }

    private void initializeServices() {
        this.blockRestrictionService = new BlockRestrictionService(this.configurationManager);
        this.capabilityService = new DebugStickCapabilityService(this.configurationManager);
    }

    private void registerRecipes() {
        this.recipeManager = new DebugStickRecipeManager(this, this.configurationManager);
        this.recipeManager.registerRecipes();
    }

    private void registerEventListeners() {
        DebugStickInteractionListener interactionListener = new DebugStickInteractionListener(this.blockRestrictionService, this.capabilityService, this.configurationManager);
        this.getServer().getPluginManager().registerEvents((Listener)interactionListener, (Plugin)this);
    }

    private void registerCommands() {
        ReloadCommand reloadCommand = new ReloadCommand(this.configurationManager);
        this.getCommand("debugstickreload").setExecutor((CommandExecutor)reloadCommand);
    }

    private void unregisterRecipes() {
        if (this.recipeManager != null) {
            this.recipeManager.unregisterRecipes();
        }
    }
}

