/*
 * Decompiled with CFR 0.152.
 */
package pl.nubet.debugstickinsurvival.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Slab;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import pl.nubet.debugstickinsurvival.config.ConfigurationManager;
import pl.nubet.debugstickinsurvival.service.BlockRestrictionService;
import pl.nubet.debugstickinsurvival.service.DebugStickCapabilityService;

public class DebugStickInteractionListener
implements Listener {
    private final BlockRestrictionService blockRestrictionService;
    private final DebugStickCapabilityService capabilityService;
    private final ConfigurationManager configurationManager;
    private final Map<UUID, BlockSnapshot> blockSnapshots = new HashMap<UUID, BlockSnapshot>();
    private final Map<UUID, Long> playerCooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_MS = 150L;

    public DebugStickInteractionListener(BlockRestrictionService blockRestrictionService, DebugStickCapabilityService capabilityService, ConfigurationManager configurationManager) {
        this.blockRestrictionService = blockRestrictionService;
        this.capabilityService = capabilityService;
        this.configurationManager = configurationManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.isDebugStickClick(event)) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.isOnCooldown(playerId)) {
            event.setCancelled(true);
            return;
        }
        this.setCooldown(playerId);
        if (this.configurationManager.areRestrictionsEnabled() && !this.blockRestrictionService.isUsageAllowed(clickedBlock)) {
            this.handleBlockRestriction(event, player);
            return;
        }
        if (this.configurationManager.areCapabilityRestrictionsEnabled()) {
            this.captureBlockState(player, clickedBlock);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteractMonitor(PlayerInteractEvent event) {
        if (!this.isDebugStickClick(event)) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        final Player player = event.getPlayer();
        final UUID playerId = player.getUniqueId();
        if (!this.blockSnapshots.containsKey(playerId)) {
            return;
        }
        new BukkitRunnable(this){
            final /* synthetic */ DebugStickInteractionListener this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                WaterlogPermissionResult waterlogResult;
                BlockSnapshot snapshot = this.this$0.blockSnapshots.remove(playerId);
                if (snapshot == null) {
                    return;
                }
                Block block = snapshot.block;
                BlockData oldData = snapshot.blockData;
                BlockData newData = block.getBlockData();
                boolean revertNeeded = false;
                String restrictionMessage = null;
                if (this.this$0.shouldCheckWaterlogging(oldData, newData) && !(waterlogResult = this.this$0.checkWaterlogPermission(player, block.getWorld())).hasPermission()) {
                    this.this$0.revertWaterlogging((Waterlogged)oldData, (Waterlogged)newData);
                    revertNeeded = true;
                    restrictionMessage = waterlogResult.getMessage();
                }
                if (this.this$0.shouldCheckSlabDoubling(oldData, newData) && !player.hasPermission("debugstickcs.doubleslab")) {
                    this.this$0.revertSlabDoubling((Slab)oldData, (Slab)newData);
                    revertNeeded = true;
                    restrictionMessage = this.this$0.configurationManager.getSlabDoublingRestrictionMessage();
                }
                if (revertNeeded) {
                    block.setBlockData(newData, false);
                    if (restrictionMessage != null) {
                        player.sendMessage(restrictionMessage);
                    }
                }
            }
        }.runTaskLater(event.getPlayer().getServer().getPluginManager().getPlugin("DebugStickCraftingInSurvival"), 1L);
    }

    private boolean isDebugStickClick(PlayerInteractEvent event) {
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_BLOCK && action != Action.LEFT_CLICK_BLOCK) {
            return false;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        return item != null && item.getType() == Material.DEBUG_STICK;
    }

    private boolean isOnCooldown(UUID playerId) {
        if (!this.playerCooldowns.containsKey(playerId)) {
            return false;
        }
        long lastUse = this.playerCooldowns.get(playerId);
        long currentTime = System.currentTimeMillis();
        return currentTime - lastUse < 150L;
    }

    private void setCooldown(UUID playerId) {
        this.playerCooldowns.put(playerId, System.currentTimeMillis());
    }

    private void captureBlockState(Player player, Block block) {
        BlockData blockData = block.getBlockData().clone();
        this.blockSnapshots.put(player.getUniqueId(), new BlockSnapshot(block, blockData));
    }

    private void handleBlockRestriction(PlayerInteractEvent event, Player player) {
        event.setCancelled(true);
        String message = this.blockRestrictionService.getRestrictionMessage();
        player.sendMessage(message);
    }

    private boolean isNetherWorld(World world) {
        return world.getEnvironment() == World.Environment.NETHER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldCheckWaterlogging(BlockData oldData, BlockData newData) {
        if (!this.configurationManager.isWaterloggingRestrictionEnabled()) return false;
        if (!(oldData instanceof Waterlogged)) return false;
        Waterlogged oldWaterlogged = (Waterlogged)oldData;
        if (!(newData instanceof Waterlogged)) return false;
        Waterlogged newWaterlogged = (Waterlogged)newData;
        if (oldWaterlogged.isWaterlogged() == newWaterlogged.isWaterlogged()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldCheckSlabDoubling(BlockData oldData, BlockData newData) {
        if (!this.configurationManager.isSlabDoublingRestrictionEnabled()) return false;
        if (!(oldData instanceof Slab)) return false;
        Slab oldSlab = (Slab)oldData;
        if (!(newData instanceof Slab)) return false;
        Slab newSlab = (Slab)newData;
        if (oldSlab.getType() == Slab.Type.DOUBLE) return false;
        if (newSlab.getType() != Slab.Type.DOUBLE) return false;
        return true;
    }

    private WaterlogPermissionResult checkWaterlogPermission(Player player, World world) {
        boolean isNether = this.isNetherWorld(world);
        if (isNether && this.configurationManager.isNetherWaterloggingRestrictionEnabled()) {
            boolean hasPermission = player.hasPermission("debugstickcs.waterlog.nether");
            String message = this.configurationManager.getNetherWaterlogRestrictionMessage();
            return hasPermission ? WaterlogPermissionResult.allowed() : WaterlogPermissionResult.denied(message);
        }
        boolean hasPermission = player.hasPermission("debugstickcs.waterlog");
        String message = this.configurationManager.getWaterlogRestrictionMessage();
        return hasPermission ? WaterlogPermissionResult.allowed() : WaterlogPermissionResult.denied(message);
    }

    private void revertWaterlogging(Waterlogged oldWaterlogged, Waterlogged newWaterlogged) {
        newWaterlogged.setWaterlogged(oldWaterlogged.isWaterlogged());
    }

    private void revertSlabDoubling(Slab oldSlab, Slab newSlab) {
        newSlab.setType(oldSlab.getType());
    }

    private static class BlockSnapshot {
        final Block block;
        final BlockData blockData;

        BlockSnapshot(Block block, BlockData blockData) {
            this.block = block;
            this.blockData = blockData;
        }
    }

    private static class WaterlogPermissionResult {
        private final boolean allowed;
        private final String message;

        private WaterlogPermissionResult(boolean allowed, String message) {
            this.allowed = allowed;
            this.message = message;
        }

        public static WaterlogPermissionResult allowed() {
            return new WaterlogPermissionResult(true, null);
        }

        public static WaterlogPermissionResult denied(String message) {
            return new WaterlogPermissionResult(false, message);
        }

        public boolean hasPermission() {
            return this.allowed;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

