/*
 * Decompiled with CFR 0.152.
 */
package pl.nubet.debugstickinsurvival.recipe;

import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import pl.nubet.debugstickinsurvival.config.ConfigurationManager;

public class DebugStickRecipeManager {
    private static final String RECIPE_KEY = "debug_stick_crafting";
    private final JavaPlugin plugin;
    private final ConfigurationManager configurationManager;
    private NamespacedKey recipeKey;

    public DebugStickRecipeManager(JavaPlugin plugin, ConfigurationManager configurationManager) {
        this.plugin = plugin;
        this.configurationManager = configurationManager;
    }

    public void registerRecipes() {
        if (!this.configurationManager.isCraftingEnabled()) {
            this.plugin.getLogger().info("Debug Stick crafting is disabled in configuration.");
            return;
        }
        try {
            this.recipeKey = new NamespacedKey((Plugin)this.plugin, RECIPE_KEY);
            ShapedRecipe recipe = this.createDebugStickRecipe();
            Bukkit.addRecipe((Recipe)recipe);
            this.plugin.getLogger().info("Debug Stick crafting recipe registered successfully.");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to register Debug Stick recipe", e);
        }
    }

    public void unregisterRecipes() {
        if (this.recipeKey != null) {
            Bukkit.removeRecipe((NamespacedKey)this.recipeKey);
            this.plugin.getLogger().info("Debug Stick crafting recipe unregistered.");
        }
    }

    private ShapedRecipe createDebugStickRecipe() {
        ItemStack debugStick = new ItemStack(Material.DEBUG_STICK, 1);
        ShapedRecipe recipe = new ShapedRecipe(this.recipeKey, debugStick);
        recipe.shape(new String[]{"  S", "NP ", "PN "});
        recipe.setIngredient('N', Material.NETHERITE_INGOT);
        recipe.setIngredient('S', Material.NETHER_STAR);
        recipe.setIngredient('P', Material.STICK);
        return recipe;
    }
}

