/*
 * Decompiled with CFR 0.152.
 */
package pl.nubet.debugstickinsurvival.service;

import org.bukkit.Material;
import org.bukkit.block.Block;
import pl.nubet.debugstickinsurvival.config.ConfigurationManager;

public class BlockRestrictionService {
    private final ConfigurationManager configurationManager;

    public BlockRestrictionService(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public boolean isUsageAllowed(Block block) {
        if (block == null) {
            return false;
        }
        if (!this.configurationManager.areRestrictionsEnabled()) {
            return true;
        }
        return !this.isBlockRestricted(block.getType());
    }

    public boolean isBlockRestricted(Material material) {
        return this.configurationManager.getExcludedBlocks().contains(material);
    }

    public String getRestrictionMessage() {
        return this.configurationManager.getRestrictionMessage();
    }
}

