/*
 * Decompiled with CFR 0.152.
 */
package org.cutt_promix.cutt_promix.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.cutt_promix.cutt_promix.block.entity.CutTableBlockEntity;
import org.cutt_promix.cutt_promix.registry.ModBlockEntities;
import org.jetbrains.annotations.Nullable;

public class CutTableBlock
extends BaseEntityBlock
implements EntityBlock {
    private static final VoxelShape TOP_BOARD = Shapes.m_83048_((double)0.0, (double)0.9375, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape FRAME_NORTH = Shapes.m_83048_((double)0.0625, (double)0.5625, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.125);
    private static final VoxelShape FRAME_EAST = Shapes.m_83048_((double)0.875, (double)0.5625, (double)0.125, (double)0.9375, (double)0.9375, (double)0.875);
    private static final VoxelShape FRAME_SOUTH = Shapes.m_83048_((double)0.0625, (double)0.5625, (double)0.875, (double)0.9375, (double)0.9375, (double)0.9375);
    private static final VoxelShape FRAME_WEST = Shapes.m_83048_((double)0.0625, (double)0.5625, (double)0.125, (double)0.125, (double)0.9375, (double)0.875);
    private static final VoxelShape MIDDLE_SUPPORT = Shapes.m_83048_((double)0.125, (double)0.5625, (double)0.125, (double)0.875, (double)0.625, (double)0.875);
    private static final VoxelShape LEG_1 = Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.8125, (double)0.9375, (double)0.5625, (double)0.9375);
    private static final VoxelShape LEG_2 = Shapes.m_83048_((double)0.8125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.5625, (double)0.1875);
    private static final VoxelShape LEG_3 = Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.1875, (double)0.5625, (double)0.1875);
    private static final VoxelShape LEG_4 = Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.8125, (double)0.1875, (double)0.5625, (double)0.9375);
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)TOP_BOARD, (VoxelShape[])new VoxelShape[]{FRAME_NORTH, FRAME_EAST, FRAME_SOUTH, FRAME_WEST, MIDDLE_SUPPORT, LEG_1, LEG_2, LEG_3, LEG_4});
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public CutTableBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(1.0f, 6.0f).m_60918_(SoundType.f_56736_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.CUT_TABLE_ENTITY.get()).m_155264_(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity;
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (player.m_21120_(hand).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!this.hasCuttingBoardNearby(level, pos)) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_ && (entity = level.m_7702_(pos)) instanceof CutTableBlockEntity) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)entity), buf -> buf.m_130064_(pos));
        }
        return InteractionResult.SUCCESS;
    }

    private boolean hasCuttingBoardNearby(Level level, BlockPos pos) {
        ResourceLocation cuttingBoardRL = new ResourceLocation("farmersdelight", "cutting_board");
        Block cuttingBoardBlock = (Block)ForgeRegistries.BLOCKS.getValue(cuttingBoardRL);
        if (cuttingBoardBlock == null || cuttingBoardBlock == Blocks.f_50016_) {
            return false;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos neighborPos = pos.m_7918_(x, y, z);
                    BlockState neighborState = level.m_8055_(neighborPos);
                    if (!neighborState.m_60713_(cuttingBoardBlock)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return null;
        }
        return CutTableBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.CUT_TABLE_ENTITY.get()), (lvl, pos, st, be) -> be.tick(lvl, pos, st));
    }
}

