/*
 * Decompiled with CFR 0.152.
 */
package org.cutt_promix.cutt_promix.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.cutt_promix.cutt_promix.block.entity.CutTableBlockEntity;
import org.cutt_promix.cutt_promix.registry.ModBlocks;
import org.cutt_promix.cutt_promix.registry.ModMenus;

public class CutTableMenu
extends AbstractContainerMenu {
    private final BlockPos blockPos;
    private final Inventory playerInventory;
    private static final int BE_SLOT_COUNT = 9;
    private static final int DISPLAY_SLOT_COUNT = 3;
    private static final int CONTAINER_SLOT_COUNT = 12;
    private static final int PLAYER_INVENTORY_START = 12;
    private static final int PLAYER_HOTBAR_START = 39;
    private static final int PLAYER_SLOT_END = 48;
    private final Container displayContainer = new SimpleContainer(3);

    public CutTableMenu(int containerId, Inventory playerInventory, BlockPos pos) {
        super((MenuType)ModMenus.CUT_TABLE_MENU.get(), containerId);
        this.blockPos = pos;
        this.playerInventory = playerInventory;
        CutTableBlockEntity blockEntity = this.getBlockEntity();
        SimpleContainer beContainer = blockEntity != null ? blockEntity.getContainer() : new SimpleContainer(9);
        int containerX = 108;
        int containerY = 28;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.m_38897_(new Slot((Container)this.getBlockEntity().getContainer(), col + row * 3, containerX + col * 18, containerY + row * 18));
            }
        }
        int browseX = 200;
        int browseY = 5;
        this.m_38897_(new ReadOnlySlot(this.displayContainer, 0, browseX - 5, browseY + 9));
        this.m_38897_(new ReadOnlySlot(this.displayContainer, 1, browseX + 18, browseY + 9));
        this.m_38897_(new ReadOnlySlot(this.displayContainer, 2, browseX + 6, browseY + 55));
        this.addPlayerSlots(playerInventory);
    }

    public Container getDisplayContainer() {
        return this.displayContainer;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    private CutTableBlockEntity getBlockEntity() {
        BlockEntity be = this.playerInventory.f_35978_.m_9236_().m_7702_(this.blockPos);
        if (be instanceof CutTableBlockEntity) {
            return (CutTableBlockEntity)be;
        }
        return null;
    }

    private void addPlayerSlots(Inventory playerInventory) {
        int backpackX = 108;
        int backpackY = 84;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, backpackX + col * 18, backpackY + row * 18));
            }
        }
        int hotbarX = 108;
        int hotbarY = 142;
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, hotbarX + col * 18, hotbarY));
        }
    }

    public boolean m_6875_(Player player) {
        return CutTableMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)this.blockPos), (Player)player, (Block)((Block)ModBlocks.ENABLE_CUTTING_BOARD.get()));
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            result = slotItem.m_41777_();
            if (slotIndex < 12) {
                if (!this.m_38903_(slotItem, 12, 48, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotItem, result);
            } else if (!this.m_38903_(slotItem, 0, 9, false) && (slotIndex < 39 ? !this.m_38903_(slotItem, 39, 48, false) : slotIndex >= 39 && !this.m_38903_(slotItem, 12, 39, false))) {
                return ItemStack.f_41583_;
            }
            if (slotItem.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotItem.m_41613_() == result.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotItem);
        }
        return result;
    }

    public static class ReadOnlySlot
    extends Slot {
        public ReadOnlySlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }
    }
}

