/*
 * Decompiled with CFR 0.152.
 */
package org.cutt_promix.cutt_promix.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.cutt_promix.cutt_promix.menu.CutTableMenu;
import org.cutt_promix.cutt_promix.network.ModMessages;
import org.cutt_promix.cutt_promix.network.PacketSetForcedRecipe;
import vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CuttpromixScreen
extends AbstractContainerScreen<CutTableMenu> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("cutt_promix", "textures/gui/cut_table_gui.png");
    private static final ResourceLocation RECIPE_ROW_TEXTURE = new ResourceLocation("cutt_promix", "textures/gui/cut_table_gui.png");
    private static final Component TAG_TOOLTIP = Component.m_237115_((String)"gui.cutt_promix.tag_marker");
    private List<CuttingBoardRecipe> recipesToDisplay = new ArrayList<CuttingBoardRecipe>();
    private ItemStack lastHeldItem = ItemStack.f_41583_;
    private ItemStack lastBoardItem = ItemStack.f_41583_;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private int listAreaX = 5;
    private int listAreaY = 18;
    private int listAreaWidth = 94;
    private int listAreaHeight = 140;
    private int rowHeight = 27;
    private int maxRowsVisible = 0;
    private boolean isToggleActive = false;
    private final int toggleX = 171;
    private final int toggleY = 56;
    private final int toggleSize = 17;
    private final int toggleU_Off = 345;
    private final int toggleV_Off = 143;
    private final int toggleU_On = 327;
    private final int toggleV_On = 143;
    private boolean displayInputTag = false;
    private boolean displayToolTag = false;
    private boolean isDraggingScrollbar = false;
    private final int scrollbarX = 94;
    private final int scrollbarY = 18;
    private final int scrollbarWidth = 6;
    private final int scrollbarHeight = 27;
    private final int scrollbarTrackHeight = 113;
    private final int scrollbarTrackY = 18;
    private ResourceLocation selectedRecipeId = null;

    public CuttpromixScreen(CutTableMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97726_ = 276;
        this.f_97727_ = 166;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.maxRowsVisible = this.listAreaHeight / this.rowHeight;
        this.lastHeldItem = ItemStack.f_41583_;
        this.lastBoardItem = ItemStack.f_41583_;
        this.updateRecipesIfNeeded();
    }

    public void updateRecipesIfNeeded() {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null || this.f_96541_.f_91073_ == null) {
            return;
        }
        LocalPlayer player = this.f_96541_.f_91074_;
        ItemStack heldItem = player.m_21205_();
        ItemStack boardItem = ItemStack.f_41583_;
        BlockEntity be = this.f_96541_.f_91073_.m_7702_(((CutTableMenu)this.f_97732_).getBlockPos().m_7494_());
        if (be instanceof CuttingBoardBlockEntity) {
            CuttingBoardBlockEntity cbe = (CuttingBoardBlockEntity)be;
            boardItem = cbe.getStoredItem();
        }
        if (!ItemStack.m_41656_((ItemStack)heldItem, (ItemStack)this.lastHeldItem) || !ItemStack.m_41656_((ItemStack)boardItem, (ItemStack)this.lastBoardItem)) {
            this.lastHeldItem = heldItem.m_41777_();
            this.lastBoardItem = boardItem.m_41777_();
            this.updateFilteredRecipes(boardItem, heldItem);
        }
    }

    private void updateFilteredRecipes(ItemStack boardItem, ItemStack heldItem) {
        this.recipesToDisplay.clear();
        if (boardItem.m_41619_() || heldItem.m_41619_()) {
            this.scrollOffset = 0;
            this.maxScroll = 0;
            ((CutTableMenu)this.f_97732_).getDisplayContainer().m_6211_();
            this.displayInputTag = false;
            this.displayToolTag = false;
            this.clearForcedRecipe();
            return;
        }
        List allRecipes = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((RecipeType)ModRecipeTypes.CUTTING.get());
        this.recipesToDisplay = allRecipes.stream().filter(recipe -> !recipe.m_7527_().isEmpty() && ((Ingredient)recipe.m_7527_().get(0)).test(boardItem) && recipe.getTool().test(heldItem)).collect(Collectors.toList());
        this.maxScroll = Math.max(0, this.recipesToDisplay.size() - this.maxRowsVisible);
        this.scrollOffset = 0;
        ((CutTableMenu)this.f_97732_).getDisplayContainer().m_6211_();
        this.displayInputTag = false;
        this.displayToolTag = false;
        this.clearForcedRecipe();
    }

    private void clearForcedRecipe() {
        if (this.isToggleActive) {
            this.isToggleActive = false;
            ModMessages.sendToServer(new PacketSetForcedRecipe((ResourceLocation)null));
        }
        this.selectedRecipeId = null;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int n;
        int u;
        int recipeIndex;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int relX = this.f_97735_;
        int relY = this.f_97736_;
        guiGraphics.m_280163_(GUI_TEXTURE, relX, relY, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
        int listX = relX + this.listAreaX;
        int listY = relY + this.listAreaY;
        guiGraphics.m_280588_(listX, listY, listX + this.listAreaWidth, listY + this.listAreaHeight);
        for (int i = 0; i < this.maxRowsVisible && (recipeIndex = i + this.scrollOffset) < this.recipesToDisplay.size(); ++i) {
            CuttingBoardRecipe recipe = this.recipesToDisplay.get(recipeIndex);
            int rowY = listY + i * this.rowHeight + i;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)RECIPE_ROW_TEXTURE);
            guiGraphics.m_280163_(RECIPE_ROW_TEXTURE, listX, rowY, 279.0f, 73.0f, 88, this.rowHeight, 512, 256);
            long cycle = this.f_96541_.f_91073_.m_46467_() / 30L;
            Ingredient inputIngredient = (Ingredient)recipe.m_7527_().get(0);
            Ingredient toolIngredient = recipe.getTool();
            ItemStack outputStack = (ItemStack)recipe.getResults().get(0);
            ItemStack inputStack = this.getCyclingStack(inputIngredient, cycle);
            ItemStack toolStack = this.getCyclingStack(toolIngredient, cycle);
            boolean inputIsTag = inputIngredient.m_43908_().length > 1;
            boolean toolIsTag = toolIngredient.m_43908_().length > 1;
            guiGraphics.m_280480_(inputStack, listX + 4, rowY + 6);
            guiGraphics.m_280480_(toolStack, listX + 31, rowY + 6);
            guiGraphics.m_280480_(outputStack, listX + 68, rowY + 6);
            if (outputStack.m_41613_() > 1) {
                guiGraphics.m_280370_(this.f_96547_, outputStack, listX + 70, rowY + 7);
            }
            int tagColor = 0xFFFFFF;
            if (inputIsTag) {
                guiGraphics.m_280488_(this.f_96547_, "*", listX + 14, rowY + 17, tagColor);
            }
            if (!toolIsTag) continue;
            guiGraphics.m_280488_(this.f_96547_, "*", listX + 41, rowY + 17, tagColor);
        }
        guiGraphics.m_280618_();
        int n2 = u = this.isToggleActive ? this.toggleU_On : this.toggleU_Off;
        if (this.isToggleActive) {
            Objects.requireNonNull(this);
            n = 143;
        } else {
            Objects.requireNonNull(this);
            n = 143;
        }
        int v = n;
        guiGraphics.m_280163_(GUI_TEXTURE, relX + this.toggleX, relY + this.toggleY, (float)u, (float)v, this.toggleSize, this.toggleSize, 512, 256);
        int browseSlot1X = relX + 195;
        int browseSlot1Y = relY + 14;
        int browseSlot2X = relX + 218;
        int browseSlot2Y = relY + 14;
        int tagColor = 0xFFFFFF;
        if (this.displayInputTag) {
            guiGraphics.m_280488_(this.f_96547_, "*", browseSlot1X + 12, browseSlot1Y + 12, tagColor);
        }
        if (this.displayToolTag) {
            guiGraphics.m_280488_(this.f_96547_, "*", browseSlot2X + 12, browseSlot2Y + 12, tagColor);
        }
        int scrollHandleYOffset = 0;
        if (this.maxScroll > 0) {
            float f = (float)this.scrollOffset / (float)this.maxScroll;
            Objects.requireNonNull(this);
            scrollHandleYOffset = (int)(f * 113.0f);
        }
        Objects.requireNonNull(this);
        int scrollHandleY = this.f_97736_ + 18 + scrollHandleYOffset;
        int u1 = this.isDraggingScrollbar ? 6 : 0;
        int v1 = 199;
        guiGraphics.m_280163_(GUI_TEXTURE, this.f_97735_ + this.scrollbarX, scrollHandleY, (float)u1, (float)v1, this.scrollbarWidth, this.scrollbarHeight, 512, 256);
    }

    private ItemStack getCyclingStack(Ingredient ingredient, long cycle) {
        ItemStack[] items = ingredient.m_43908_();
        if (items.length == 0) {
            return ItemStack.f_41583_;
        }
        return items[(int)(cycle % (long)items.length)];
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.updateRecipesIfNeeded();
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.renderRecipeListTooltips(guiGraphics, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isHovering(this.f_97735_ + 171, this.f_97736_ + 56, 17, 17, (int)mouseX, (int)mouseY)) {
            if (!this.isToggleActive) {
                if (this.selectedRecipeId == null) {
                    return true;
                }
                this.isToggleActive = true;
            } else {
                this.isToggleActive = false;
            }
            ResourceLocation idToSend = this.isToggleActive ? this.selectedRecipeId : null;
            ModMessages.sendToServer(new PacketSetForcedRecipe(idToSend));
            return true;
        }
        int scrollHandleYOffset = 0;
        if (this.maxScroll > 0) {
            float f = (float)this.scrollOffset / (float)this.maxScroll;
            Objects.requireNonNull(this);
            scrollHandleYOffset = (int)(f * 113.0f);
        }
        int handleX = this.f_97735_ + this.scrollbarX;
        Objects.requireNonNull(this);
        int handleY = this.f_97736_ + 18 + scrollHandleYOffset;
        if (this.isHovering(handleX, handleY, this.scrollbarWidth, this.scrollbarHeight, (int)mouseX, (int)mouseY)) {
            this.isDraggingScrollbar = true;
            return true;
        }
        int listX = this.f_97735_ + this.listAreaX;
        int listY = this.f_97736_ + this.listAreaY;
        if (mouseY >= (double)listY && mouseY < (double)(listY + this.listAreaHeight) && mouseX >= (double)listX && mouseX < (double)(listX + this.listAreaWidth)) {
            int targetRowIndex = -1;
            for (int i = 0; i < this.maxRowsVisible; ++i) {
                int renderedRowY = listY + i * this.rowHeight + i;
                if (!(mouseY >= (double)renderedRowY) || !(mouseY < (double)(renderedRowY + this.rowHeight))) continue;
                targetRowIndex = i;
                break;
            }
            if (targetRowIndex == -1) {
                return super.m_6375_(mouseX, mouseY, button);
            }
            int recipeIndex = targetRowIndex + this.scrollOffset;
            if (recipeIndex < this.recipesToDisplay.size()) {
                if (this.isToggleActive || this.selectedRecipeId != null) {
                    this.isToggleActive = false;
                    ModMessages.sendToServer(new PacketSetForcedRecipe((ResourceLocation)null));
                    System.out.println("\u9009\u62e9\u65b0\u914d\u65b9\u524d\u91cd\u7f6e\u65e7\u5f3a\u5236\u914d\u65b9");
                }
                CuttingBoardRecipe recipe = this.recipesToDisplay.get(recipeIndex);
                long cycle = this.f_96541_.f_91073_.m_46467_() / 30L;
                Ingredient inputIngredient = (Ingredient)recipe.m_7527_().get(0);
                Ingredient toolIngredient = recipe.getTool();
                ItemStack outputStack = (ItemStack)recipe.getResults().get(0);
                ItemStack inputStack = this.getCyclingStack(inputIngredient, cycle);
                ItemStack toolStack = this.getCyclingStack(toolIngredient, cycle);
                ((CutTableMenu)this.f_97732_).getDisplayContainer().m_6836_(0, inputStack.m_41777_());
                ((CutTableMenu)this.f_97732_).getDisplayContainer().m_6836_(1, toolStack.m_41777_());
                ((CutTableMenu)this.f_97732_).getDisplayContainer().m_6836_(2, outputStack.m_41777_());
                this.displayInputTag = inputIngredient.m_43908_().length > 1;
                this.displayToolTag = toolIngredient.m_43908_().length > 1;
                this.selectedRecipeId = recipe.m_6423_();
                if (this.isToggleActive) {
                    ModMessages.sendToServer(new PacketSetForcedRecipe(this.selectedRecipeId));
                }
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDraggingScrollbar = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingScrollbar) {
            Objects.requireNonNull(this);
            int trackTop = this.f_97736_ + 18;
            double relativeY = mouseY - (double)trackTop;
            relativeY = Math.max(0.0, relativeY);
            relativeY = Math.min((double)this.scrollbarTrackHeight, relativeY);
            if (this.maxScroll > 0) {
                this.scrollOffset = (int)Math.round(relativeY / (double)this.scrollbarTrackHeight * (double)this.maxScroll);
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    private void renderRecipeListTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int rowIndex;
        int recipeIndex;
        int listX = this.f_97735_ + this.listAreaX;
        int listY = this.f_97736_ + this.listAreaY;
        if (mouseY >= listY && mouseY < listY + this.listAreaHeight && mouseX >= listX && mouseX < listX + this.listAreaWidth && (recipeIndex = (rowIndex = (mouseY - listY) / this.rowHeight) + this.scrollOffset) < this.recipesToDisplay.size()) {
            CuttingBoardRecipe recipe = this.recipesToDisplay.get(recipeIndex);
            int rowY = listY + rowIndex * this.rowHeight;
            long cycle = this.f_96541_.f_91073_.m_46467_() / 30L;
            Ingredient inputIngredient = (Ingredient)recipe.m_7527_().get(0);
            Ingredient toolIngredient = recipe.getTool();
            ItemStack outputStack = (ItemStack)recipe.getResults().get(0);
            if (this.isHovering(listX + 4, rowY + 5, 16, 16, mouseX, mouseY)) {
                this.renderTagTooltip(guiGraphics, mouseX, mouseY, inputIngredient, this.getCyclingStack(inputIngredient, cycle));
            } else if (this.isHovering(listX + 35, rowY + 5, 16, 16, mouseX, mouseY)) {
                this.renderTagTooltip(guiGraphics, mouseX, mouseY, toolIngredient, this.getCyclingStack(toolIngredient, cycle));
            } else if (this.isHovering(listX + 66, rowY + 5, 16, 16, mouseX, mouseY)) {
                guiGraphics.m_280153_(this.f_96547_, outputStack, mouseX, mouseY);
            }
        }
    }

    private void renderTagTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, Ingredient ingredient, ItemStack stack) {
        List tooltip = CuttpromixScreen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)stack);
        if (ingredient.m_43908_().length > 1) {
            tooltip.add(Component.m_237119_());
            tooltip.add(TAG_TOOLTIP);
        }
        guiGraphics.m_280677_(this.f_96547_, tooltip, stack.m_150921_(), mouseX, mouseY);
    }

    private boolean isHovering(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, 150, 6, 0x404040);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int listX = this.f_97735_ + this.listAreaX;
        int listY = this.f_97736_ + this.listAreaY;
        if (mouseY >= (double)listY && mouseY < (double)(listY + this.listAreaHeight) && mouseX >= (double)listX && mouseX < (double)(listX + this.listAreaWidth)) {
            this.scrollOffset -= (int)delta;
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            } else if (this.scrollOffset > this.maxScroll) {
                this.scrollOffset = this.maxScroll;
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }
}

