/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.util;

import git.jbredwards.fluidlogged_api.api.block.IFluidloggable;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.event.FluidloggedEvent;
import git.jbredwards.fluidlogged_api.api.fluid.ICompatibleFluid;
import git.jbredwards.fluidlogged_api.api.network.MessageUtils;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.world.IChunkProvider;
import git.jbredwards.fluidlogged_api.api.world.IWorldProvider;
import git.jbredwards.fluidlogged_api.mod.FluidloggedAPI;
import git.jbredwards.fluidlogged_api.mod.asm.iface.ICanFluidFlowHandler;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IConfigFluidBox;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.forge.PluginBlockFluidClassic;
import git.jbredwards.fluidlogged_api.mod.common.fluid.util.FluidCache;
import git.jbredwards.fluidlogged_api.mod.common.message.SMessageSyncFluidState;
import git.jbredwards.fluidlogged_api.mod.common.message.SMessageVaporizeEffects;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class FluidloggedUtils {
    @Nonnull
    public static FluidState getFluidState(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        Chunk chunk = world instanceof IChunkProvider ? ((IChunkProvider)world).getChunk((Vec3i)pos) : null;
        return chunk != null ? FluidloggedUtils.getFluidState(chunk, pos) : FluidloggedUtils.getFluidState(world, pos, world.func_180495_p(pos));
    }

    @Nonnull
    public static FluidState getFluidState(@Nullable IBlockAccess world, @Nonnull BlockPos pos, @Nullable IBlockState state) {
        return FluidloggedUtils.isFluid(state) ? FluidState.of(state) : FluidState.get(world, pos);
    }

    @Nonnull
    public static FluidState getFluidState(@Nonnull Chunk chunk, @Nonnull BlockPos pos) {
        return FluidloggedUtils.getFluidState(chunk, pos, chunk.func_177435_g(pos));
    }

    @Nonnull
    public static FluidState getFluidState(@Nullable Chunk chunk, @Nonnull BlockPos pos, @Nullable IBlockState state) {
        return FluidloggedUtils.isFluid(state) ? FluidState.of(state) : FluidState.getFromProvider((ICapabilityProvider)chunk, pos);
    }

    @Nonnull
    public static IBlockState getFluidOrReal(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        Chunk chunk = world instanceof IChunkProvider ? ((IChunkProvider)world).getChunk((Vec3i)pos) : null;
        return chunk != null ? FluidloggedUtils.getFluidOrReal(chunk, pos) : FluidloggedUtils.getFluidOrReal(world, pos, world.func_180495_p(pos));
    }

    @Nonnull
    public static IBlockState getFluidOrReal(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (FluidloggedUtils.isFluid(state)) {
            return state;
        }
        FluidState fluidState = FluidState.get(world, pos);
        return fluidState.isEmpty() ? state : fluidState.getState();
    }

    @Nonnull
    public static IBlockState getFluidOrReal(@Nonnull Chunk chunk, @Nonnull BlockPos pos) {
        return FluidloggedUtils.getFluidOrReal(chunk, pos, chunk.func_177435_g(pos));
    }

    @Nonnull
    public static IBlockState getFluidOrReal(@Nullable Chunk chunk, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (FluidloggedUtils.isFluid(state)) {
            return state;
        }
        FluidState fluidState = FluidState.getFromProvider((ICapabilityProvider)chunk, pos);
        return fluidState.isEmpty() ? state : fluidState.getState();
    }

    public static boolean setFluidToAir(@Nonnull World world, @Nonnull BlockPos pos, @Nullable IBlockState here, int blockFlags) {
        if (here != null) {
            return FluidloggedUtils.isFluid(here) ? world.func_180501_a(pos, BlockStateContainer.field_186020_a, blockFlags | 0x20) : FluidloggedUtils.setFluidState(world, pos, here, FluidState.EMPTY, false, blockFlags);
        }
        IBlockState state = world.func_180495_p(pos);
        return FluidloggedUtils.isFluid(state) ? world.func_180501_a(pos, BlockStateContainer.field_186020_a, blockFlags | 0x20) : FluidloggedUtils.setFluidState(world, pos, state, FluidState.EMPTY, false, blockFlags);
    }

    public static boolean setFluidState(@Nonnull World world, @Nonnull BlockPos pos, @Nullable IBlockState here, @Nonnull FluidState fluidState, boolean checkVaporize) {
        return FluidloggedUtils.setFluidState(world, pos, here, fluidState, checkVaporize, 3);
    }

    public static boolean setFluidState(@Nonnull World world, @Nonnull BlockPos pos, @Nullable IBlockState here, @Nonnull FluidState fluidState, boolean checkVaporize, int blockFlags) {
        EnumActionResult result;
        FluidloggedEvent event;
        if (world.func_189509_E(pos) || world.func_175624_G() == WorldType.field_180272_g) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        if (here == null) {
            here = chunk.func_177435_g(pos);
        }
        if (fluidState != FluidState.EMPTY && FluidloggedUtils.isFluid(here)) {
            return false;
        }
        IFluidStateCapability cap = IFluidStateCapability.get((ICapabilityProvider)chunk);
        if (cap == null) {
            throw new NullPointerException("There was a critical internal error involving the Fluidlogged API mod, notify the mod author!");
        }
        if (cap.getContainer(pos.func_177956_o()).getFluidState(pos, FluidState.EMPTY) == fluidState) {
            return false;
        }
        pos = pos.func_185334_h();
        int precipitationIndex = (pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF;
        if (pos.func_177956_o() >= chunk.field_76638_b[precipitationIndex] - 1) {
            chunk.field_76638_b[precipitationIndex] = -999;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new FluidloggedEvent(world, chunk, pos, here, fluidState, checkVaporize, blockFlags))) && event.getResult() != Event.Result.DEFAULT) {
            return event.getResult() == Event.Result.ALLOW;
        }
        if (event.doesVaporize()) {
            FluidloggedUtils.playVaporizeEffects(world, pos, event.getFluidStack());
            return true;
        }
        if (here.func_177230_c() instanceof IFluidloggable && (result = ((IFluidloggable)here.func_177230_c()).onFluidChange(world, pos, here, event.fluidState, event.blockFlags)) != EnumActionResult.PASS) {
            return result == EnumActionResult.SUCCESS;
        }
        FluidloggedUtils.setFluidState_Internal(world, chunk, here, pos, event.fluidState, event.blockFlags);
        return true;
    }

    public static void setFluidState_Internal(@Nonnull World world, @Nonnull Chunk chunk, @Nonnull IBlockState here, @Nonnull BlockPos pos, @Nonnull FluidState fluidState, int blockFlags) {
        IFluidStateCapability cap = IFluidStateCapability.get((ICapabilityProvider)chunk);
        if (cap == null) {
            throw new NullPointerException("There was a critical internal error involving the Fluidlogged API mod, notify the mod author!");
        }
        if (world.field_72995_K) {
            if (!cap.getContainer(pos.func_177956_o()).setFluidState(pos, fluidState)) {
                return;
            }
        } else {
            if (!cap.getContainer(pos.func_177956_o()).setFluidState(pos, fluidState)) {
                return;
            }
            if ((blockFlags & 2) != 0) {
                MessageUtils.sendToAllTracking((IMessage)new SMessageSyncFluidState(pos, fluidState, true), chunk, FluidloggedAPI.WRAPPER);
            }
            fluidState.getBlock().func_176213_c(world, pos, fluidState.getState());
        }
        FluidloggedUtils.relightFluidBlock(world, pos, chunk, fluidState);
        world.markAndNotifyBlock(pos, chunk, here, here, blockFlags);
    }

    public static void relightFluidBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull FluidState fluidState) {
        FluidloggedUtils.relightFluidBlock(world, pos, world.func_175726_f(pos), fluidState);
    }

    public static void relightFluidBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Chunk chunk, @Nonnull FluidState fluidState) {
        int x = pos.func_177958_n() & 0xF;
        int z = pos.func_177952_p() & 0xF;
        int height = chunk.func_76611_b(x, z);
        if (!fluidState.isEmpty() && fluidState.getState().getLightOpacity((IBlockAccess)world, pos) > 0) {
            if (pos.func_177956_o() >= height) {
                chunk.func_76615_h(x, pos.func_177956_o() + 1, z);
            }
        } else if (pos.func_177956_o() == height - 1) {
            chunk.func_76615_h(x, pos.func_177956_o(), z);
        }
        if (chunk.func_177413_a(EnumSkyBlock.SKY, pos) > 0 || chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) > 0) {
            chunk.func_76595_e(x, z);
        }
        world.field_72984_F.func_76320_a("checkLight");
        world.func_175664_x(pos);
        world.field_72984_F.func_76319_b();
    }

    public static void notifyFluids(@Nonnull World world, @Nonnull BlockPos pos, @Nullable FluidState fluidState, boolean notifyHere, EnumFacing ... except) {
        FluidCache cache = new FluidCache((IBlockAccess)world, (Vec3i)pos, 1, 1);
        EnumSet<EnumFacing> set = EnumSet.allOf(EnumFacing.class);
        IBlockState source = (fluidState == null ? cache.getFluidState((Vec3i)pos) : fluidState).getState();
        if (except != null) {
            Arrays.asList(except).forEach(set::remove);
        }
        if (ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (IBlockState)source, set, (boolean)false).isCanceled()) {
            return;
        }
        if (notifyHere) {
            source.func_189546_a(world, pos, source.func_177230_c(), pos);
        }
        for (EnumFacing facing : set) {
            BlockPos offset = pos.func_177972_a(facing);
            FluidState neighbor = FluidloggedUtils.getFluidState(cache, offset);
            neighbor.getState().func_189546_a(world, offset, source.func_177230_c(), pos);
        }
    }

    public static boolean canFluidFlow(@Nonnull IBlockAccess access, @Nonnull BlockPos pos, @Nonnull IBlockState here, @Nonnull EnumFacing side) {
        IBlockState actualState = here.func_185899_b(access, pos = pos.func_185334_h());
        ICanFluidFlowHandler override = ICanFluidFlowHandler.Accessor.getOverride(actualState);
        if (override != null) {
            return override.canFluidFlow(access, pos, actualState, side);
        }
        return here.func_177230_c() instanceof IFluidloggable ? ((IFluidloggable)here.func_177230_c()).canFluidFlow(access, pos, here, side) : here.func_193401_d(access, pos, side) != BlockFaceShape.SOLID;
    }

    public static boolean isCompatibleFluid(@Nullable Fluid fluid1, @Nullable Fluid fluid2) {
        if (fluid1 == null || fluid2 == null) {
            return false;
        }
        if (fluid1.equals(fluid2)) {
            return true;
        }
        int compat1 = fluid1 instanceof ICompatibleFluid ? ((ICompatibleFluid)fluid1).getFluidCompatibility(fluid2) : 0;
        int compat2 = fluid2 instanceof ICompatibleFluid ? ((ICompatibleFluid)fluid2).getFluidCompatibility(fluid1) : 0;
        return (compat1 == compat2 ? compat1 : Math.max(compat1, compat2) - Math.min(compat1, compat2)) > 0;
    }

    public static boolean isCompatibleFluid(@Nonnull FluidState fluidState1, @Nonnull FluidState fluidState2) {
        return FluidloggedUtils.isCompatibleFluid(fluidState1.getFluid(), fluidState2.getFluid());
    }

    @Nullable
    public static Fluid getFluidFromState(@Nullable IBlockState state) {
        if (state == null) {
            return null;
        }
        if (state.func_177230_c() instanceof IFluidBlock) {
            return ((IFluidBlock)state.func_177230_c()).getFluid();
        }
        Material material = state.func_185904_a();
        return material == Material.field_151586_h ? FluidRegistry.WATER : (material == Material.field_151587_i ? FluidRegistry.LAVA : null);
    }

    @Nullable
    public static Fluid getFluidFromBlock(@Nullable Block block) {
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).getFluid();
        }
        if (block == null) {
            return null;
        }
        Material material = block.func_176223_P().func_185904_a();
        return material == Material.field_151586_h ? FluidRegistry.WATER : (material == Material.field_151587_i ? FluidRegistry.LAVA : null);
    }

    public static boolean isFluid(@Nullable IBlockState state) {
        if (state == null) {
            return false;
        }
        if (state.func_177230_c() instanceof IFluidBlock) {
            return true;
        }
        Material material = state.func_185904_a();
        return material == Material.field_151586_h || material == Material.field_151587_i;
    }

    public static boolean isFluid(@Nullable Block block) {
        if (block instanceof IFluidBlock) {
            return true;
        }
        if (block == null) {
            return false;
        }
        Material material = block.func_176223_P().func_185904_a();
        return material == Material.field_151586_h || material == Material.field_151587_i;
    }

    public static boolean isStateFluidloggable(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull FluidState fluid) {
        return fluid.isFluidloggable() && fluid.getFluidBlockHandler().isStateFluidloggable(state, world, pos, fluid);
    }

    public static boolean canCreateSource(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        return ForgeEventFactory.canCreateFluidSource((World)world, (BlockPos)pos, (IBlockState)state, (boolean)(state.func_177230_c() instanceof BlockLiquid ? state.func_185904_a() == Material.field_151586_h : state.func_177230_c() instanceof PluginBlockFluidClassic.Accessor && ((PluginBlockFluidClassic.Accessor)state.func_177230_c()).canCreateSource_Public()));
    }

    public static boolean canFluidOccupy(@Nonnull IBlockState actualState, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull FluidState fluidState) {
        if (FluidloggedUtils.canFluidFlow(world, pos, actualState, fluidState.getDownDensityFace())) {
            return true;
        }
        if (!fluidState.isValid()) {
            return false;
        }
        AxisAlignedBB fluidBB = fluidState.getFluidBox(world, pos);
        IConfigFluidBox config = IConfigFluidBox.get(actualState);
        if (config.getBoxes() != null) {
            return config.getBoxes().stream().noneMatch(box -> box.max + (double)pos.func_177956_o() >= fluidBB.field_72337_e && box.min + (double)pos.func_177956_o() <= fluidBB.field_72338_b);
        }
        ArrayList<AxisAlignedBB> colliding = new ArrayList<AxisAlignedBB>();
        actualState.func_185908_a(IWorldProvider.getWorld(world), pos, fluidBB, colliding, null, true);
        colliding.removeIf(bb -> bb.field_72337_e < fluidBB.field_72337_e || bb.field_72338_b > fluidBB.field_72338_b);
        if (colliding.isEmpty()) {
            return true;
        }
        Rectangle2D[] trimmed = (Rectangle2D[])colliding.stream().map(bb -> new Rectangle2D.Double(bb.field_72340_a, bb.field_72339_c, bb.field_72336_d - bb.field_72340_a, bb.field_72334_f - bb.field_72339_c)).map(new Rectangle2D.Double(pos.func_177958_n(), pos.func_177952_p(), 1.0, 1.0)::createIntersection).toArray(Rectangle2D[]::new);
        double total = 0.0;
        double overlapping = 0.0;
        for (int i = 0; i < trimmed.length; ++i) {
            total += trimmed[i].getWidth() * trimmed[i].getHeight();
            for (int j = i + 1; j < trimmed.length; ++j) {
                if (!trimmed[i].intersects(trimmed[j])) continue;
                Rectangle2D overlap = trimmed[i].createIntersection(trimmed[j]);
                overlapping += overlap.getWidth() * overlap.getHeight();
            }
        }
        return total - overlapping < 1.0;
    }

    public static void playVaporizeEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull FluidStack fluidStack) {
        if (!world.field_72995_K) {
            fluidStack.getFluid().vaporize(null, world, pos, fluidStack);
            FluidloggedAPI.WRAPPER.sendToAllAround((IMessage)new SMessageVaporizeEffects(fluidStack, pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 64.0));
        }
    }

    @Nonnull
    public static Optional<Vec3d> positionDripParticle(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull FluidState fluidState) {
        IBlockState under;
        int densityDir = fluidState.getDensityDir();
        Chunk chunk = world.func_175726_f(pos);
        IBlockState here = chunk.func_177435_g(pos);
        IBlockState below = chunk.func_177435_g(pos.func_177981_b(densityDir));
        if (here != fluidState.getState() && !FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos, here, fluidState.getDownDensityFace()) && !below.func_185904_a().func_76230_c() && FluidloggedUtils.getFluidState(chunk, pos.func_177981_b(densityDir), below).isEmpty()) {
            return Optional.of(new Vec3d((Vec3i)pos).func_72441_c(world.field_73012_v.nextDouble(), densityDir < 0 ? -0.05 : 1.05, world.field_73012_v.nextDouble()));
        }
        if (!FluidloggedUtils.canFluidFlow((IBlockAccess)world, pos.func_177981_b(densityDir), below, fluidState.getUpDensityFace()) && FluidloggedUtils.getFluidState(chunk, pos.func_177981_b(densityDir), below).isEmpty() && !(under = chunk.func_177435_g(pos.func_177981_b(densityDir << 1))).func_185904_a().func_76230_c() && FluidloggedUtils.getFluidState(chunk, pos.func_177981_b(densityDir << 1), under).isEmpty()) {
            return Optional.of(new Vec3d((Vec3i)pos).func_72441_c(world.field_73012_v.nextDouble(), densityDir < 0 ? -1.05 : 2.05, world.field_73012_v.nextDouble()));
        }
        return Optional.empty();
    }

    @Deprecated
    public static boolean isFluidloggableFluid(@Nullable Block fluid) {
        return FluidState.of(fluid).isFluidloggable();
    }

    @Deprecated
    public static boolean isFluidloggableFluid(@Nullable IBlockState fluid, @Nullable World world, @Nullable BlockPos pos) {
        return FluidState.of(fluid).isFluidloggable();
    }

    @Deprecated
    public static boolean isStateFluidloggable(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Fluid fluid) {
        return FluidloggedUtils.isStateFluidloggable(state, (IBlockAccess)world, pos, FluidState.of(fluid));
    }
}

