/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.world;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IWorldProvider {
    @Nonnull
    public World getWorld();

    public static World getWorld(@Nullable IBlockAccess access) {
        if (access instanceof IWorldProvider) {
            return ((IWorldProvider)access).getWorld();
        }
        if (access == null) {
            return null;
        }
        if (!FMLLaunchHandler.isDeobfuscatedEnvironment() && FMLCommonHandler.instance().getSide().isClient() && FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return Objects.requireNonNull(IWorldProvider.getWorldClient(), "Cannot get client world while none is loaded.");
        }
        throw new IllegalArgumentException("Could not get world from: \"" + access.getClass().toGenericString() + '\"');
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static World getWorldClient() {
        return FMLClientHandler.instance().getWorldClient();
    }
}

