/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod;

import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.client.optifine.OptifineHelper;
import git.jbredwards.fluidlogged_api.mod.common.capability.util.FluidStateStorage;
import git.jbredwards.fluidlogged_api.mod.common.command.CommandFluidloggedAPI;
import git.jbredwards.fluidlogged_api.mod.common.command.CommandReloadConfig;
import git.jbredwards.fluidlogged_api.mod.common.command.CommandSetFluidState;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigs;
import git.jbredwards.fluidlogged_api.mod.common.config.handler.LegacyConfigHandler;
import git.jbredwards.fluidlogged_api.mod.common.datafix.FluidloggedAPIFixableData;
import git.jbredwards.fluidlogged_api.mod.common.datafix.LegacyDataFixer;
import git.jbredwards.fluidlogged_api.mod.common.datafix.ToFluidloggedDataFixer;
import git.jbredwards.fluidlogged_api.mod.common.datafix.modded.DynamicTreesDataFixer;
import git.jbredwards.fluidlogged_api.mod.common.datafix.modded.GalacticraftDataFixer;
import git.jbredwards.fluidlogged_api.mod.common.datafix.modded.TropicraftDataFixer;
import git.jbredwards.fluidlogged_api.mod.common.message.CMessageSyncGameRule;
import git.jbredwards.fluidlogged_api.mod.common.message.SMessageCommandPrint;
import git.jbredwards.fluidlogged_api.mod.common.message.SMessageSyncConfigs;
import git.jbredwards.fluidlogged_api.mod.common.message.SMessageSyncFluidState;
import git.jbredwards.fluidlogged_api.mod.common.message.SMessageSyncFluidStates;
import git.jbredwards.fluidlogged_api.mod.common.message.SMessageSyncGameRule;
import git.jbredwards.fluidlogged_api.mod.common.message.SMessageVaporizeEffects;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="fluidlogged_api", useMetadata=true, guiFactory="git.jbredwards.fluidlogged_api.mod.client.config.gui.FluidloggedAPIGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public final class FluidloggedAPI {
    @Nonnull
    public static final String MODID = "fluidlogged_api";
    @Nonnull
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"fluidlogged_api");
    @Nonnull
    public static final SimpleNetworkWrapper WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel("fluidlogged_api");
    @Nullable
    private static String creditsKey;
    @Nullable
    private static String descKey;
    public static final boolean isAquaAcrobatics;
    public static final boolean isChiseledMe;
    public static final boolean isCubicChunks;
    public static final boolean isDynamicLights;
    public static final boolean isGalacticraft;
    public static final boolean isRandomThings;
    public static final boolean isSubaquatic;

    @Mod.EventHandler
    static void preInit(@Nonnull FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(IFluidStateCapability.class, (Capability.IStorage)FluidStateStorage.INSTANCE, () -> {
            throw new UnsupportedOperationException();
        });
        WRAPPER.registerMessage((IMessageHandler)SMessageSyncFluidState.Handler.INSTANCE, SMessageSyncFluidState.class, 1, Side.CLIENT);
        WRAPPER.registerMessage((IMessageHandler)SMessageSyncFluidStates.Handler.INSTANCE, SMessageSyncFluidStates.class, 2, Side.CLIENT);
        WRAPPER.registerMessage((IMessageHandler)SMessageVaporizeEffects.Handler.INSTANCE, SMessageVaporizeEffects.class, 3, Side.CLIENT);
        WRAPPER.registerMessage((IMessageHandler)CMessageSyncGameRule.Handler.INSTANCE, CMessageSyncGameRule.class, 4, Side.SERVER);
        WRAPPER.registerMessage((IMessageHandler)SMessageSyncGameRule.Handler.INSTANCE, SMessageSyncGameRule.class, 5, Side.CLIENT);
        WRAPPER.registerMessage((IMessageHandler)SMessageCommandPrint.Handler.INSTANCE, SMessageCommandPrint.class, 6, Side.CLIENT);
        WRAPPER.registerMessage((IMessageHandler)SMessageSyncConfigs.Handler.INSTANCE, SMessageSyncConfigs.class, 7, Side.CLIENT);
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    static void preInitClient(@Nonnull FMLPreInitializationEvent event) {
        if (FMLClientHandler.instance().hasOptifine()) {
            OptifineHelper.setWaterColorHelper();
        }
    }

    @Mod.EventHandler
    static void init(@Nonnull FMLInitializationEvent event) {
        ForgeRegistries.BLOCKS.getValuesCollection().stream().filter(FluidloggedUtils::isFluid).forEach(b -> {
            b.field_149783_u = true;
        });
        if (Loader.isModLoaded((String)"dynamictrees")) {
            DynamicTreesDataFixer.register();
        }
        if (Loader.isModLoaded((String)"tropicraft")) {
            TropicraftDataFixer.register();
        }
        if (isGalacticraft) {
            GalacticraftDataFixer.register();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    static void initClient(@Nonnull FMLInitializationEvent event) {
        Optional.ofNullable(Loader.instance().getIndexedModList().get(MODID)).ifPresent(mod -> {
            ReflectionHelper.setPrivateValue(FMLModContainer.class, (Object)((FMLModContainer)mod), (Object)ModContainer.Disableable.NEVER, (String[])new String[]{"disableability"});
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)((ISelectiveResourceReloadListener)(manager, condition) -> {
                if (condition.test(VanillaResourceType.LANGUAGES) && mod.getMetadata() != null) {
                    mod.getMetadata().credits = I18n.func_135052_a((String)(creditsKey == null ? (creditsKey = mod.getMetadata().credits) : creditsKey), (Object[])new Object[0]).replace("\\n", "\n");
                    mod.getMetadata().description = I18n.func_135052_a((String)(descKey == null ? (descKey = mod.getMetadata().description) : descKey), (Object[])new Object[0]);
                }
            }));
        });
    }

    @Mod.EventHandler
    static void postInit(@Nonnull FMLPostInitializationEvent event) {
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151129_at, (Object)DispenseFluidContainer.getInstance());
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151131_as, (Object)DispenseFluidContainer.getInstance());
    }

    @Mod.EventHandler
    static void loadComplete(@Nonnull FMLLoadCompleteEvent event) throws IOException {
        FluidloggedAPIFixableData.register("legacy_adapter", 0, LegacyDataFixer::fix);
        FluidloggedAPIFixableData.register("to_fluid_state", FluidloggedAPIFixableData.getToFluidStateDataVersion(), ToFluidloggedDataFixer::fix);
        LegacyConfigHandler.convertOldFile();
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    static void loadCompleteClient(@Nonnull FMLLoadCompleteEvent event) {
        if (FMLClientHandler.instance().hasOptifine()) {
            OptifineHelper.onLoadComplete();
        }
    }

    @Mod.EventHandler
    static void start(@Nonnull FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSetFluidState(null));
        event.registerServerCommand((ICommand)new CommandReloadConfig(null, "reloadFluidloggedAPI"));
        event.registerServerCommand((ICommand)new CommandFluidloggedAPI(MODID));
        event.registerServerCommand((ICommand)new CommandFluidloggedAPI("fluidlogged"));
    }

    @Mod.EventHandler
    static void aboutToStart(@Nonnull FMLServerAboutToStartEvent event) throws IOException {
        if (isGalacticraft) {
            GalacticraftDataFixer.init();
        }
        LegacyDataFixer.init();
        ForgeModContainer.fixVanillaCascading = true;
        FluidloggedAPIConfigs.initConfigs(event.getServer(), false);
    }

    @Mod.EventHandler
    static void stopped(@Nonnull FMLServerStoppedEvent event) {
        if (isGalacticraft) {
            GalacticraftDataFixer.reset();
        }
        LegacyDataFixer.reset();
    }

    static {
        isAquaAcrobatics = Loader.isModLoaded((String)"aquaacrobatics");
        isChiseledMe = Loader.isModLoaded((String)"chiseled_me");
        isCubicChunks = Loader.isModLoaded((String)"cubicchunks");
        isDynamicLights = Loader.isModLoaded((String)"dynamiclights");
        isGalacticraft = Loader.isModLoaded((String)"galacticraftcore");
        isRandomThings = Loader.isModLoaded((String)"randomthings");
        isSubaquatic = Loader.isModLoaded((String)"subaquatic");
    }
}

