/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.iface;

import git.jbredwards.fluidlogged_api.mod.common.config.util.ConfigPredicate;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IConfigAccessor {
    @Nonnull
    public static final Set<IConfigAccessor> BLACKLIST_CACHE = new HashSet<IConfigAccessor>();
    @Nonnull
    public static final Set<IConfigAccessor> WHITELIST_CACHE = new HashSet<IConfigAccessor>();

    @Nullable
    public ConfigPredicate getBlacklistPredicate();

    public void setBlacklistPredicate(@Nullable ConfigPredicate var1);

    @Nullable
    public ConfigPredicate getWhitelistPredicate();

    public void setWhitelistPredicate(@Nullable ConfigPredicate var1);

    public static void setBlacklistAndCache(@Nonnull IConfigAccessor state, @Nullable ConfigPredicate predicate) {
        state.setBlacklistPredicate(predicate);
        if (predicate != null) {
            BLACKLIST_CACHE.add(state);
        }
    }

    public static void setWhitelistAndCache(@Nonnull IConfigAccessor state, @Nullable ConfigPredicate predicate) {
        state.setWhitelistPredicate(predicate);
        if (predicate != null) {
            WHITELIST_CACHE.add(state);
        }
    }
}

