/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.astral_sorcery;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import hellfirepvp.astralsorcery.common.block.fluid.FluidBlockLiquidStarlight;
import hellfirepvp.astralsorcery.common.entities.EntityStarlightReacttant;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemRockCrystalBase;
import hellfirepvp.astralsorcery.common.util.EntityUtils;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.OreDictAlias;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginEntityCrystal
implements IASMPlugin {
    @Override
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals("increaseSize");
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (this.checkMethod(insn, obfuscated ? "func_175698_g" : "setBlockToAir")) {
            instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(1));
            instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(6));
            instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "setFluidToAir", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z"));
            instructions.remove(insn);
            return true;
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        if (classNode.name.equals("hellfirepvp/astralsorcery/common/entities/EntityItemStardust")) {
            this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("canCraft"), "canCraft", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;)Z", (GeneratorAdapter generator) -> {
                generator.visitVarInsn(25, 0);
                generator.visitFieldInsn(178, classNode.name, "boxCraft", "Lnet/minecraft/util/math/AxisAlignedBB;");
            });
        }
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("getCraftMode"), "getCraftMode", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;)I", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(178, classNode.name, "boxCraft", "Lnet/minecraft/util/math/AxisAlignedBB;");
        });
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("isInLiquidStarlight"), "isInLiquidStarlight", "(Lnet/minecraft/entity/Entity;)Z", (GeneratorAdapter generator) -> generator.visitVarInsn(25, 1));
        return classNode.methods.stream().anyMatch(method -> this.isMethodValid((MethodNode)method, obfuscated));
    }

    public static final class Hooks {
        public static boolean canCraft(@Nonnull Entity crystal, @Nonnull AxisAlignedBB boxCraft) {
            if (!((EntityStarlightReacttant)crystal).isInLiquidStarlight(crystal)) {
                return false;
            }
            BlockPos pos = new BlockPos(crystal.field_70165_t, crystal.field_70163_u, crystal.field_70161_v);
            if (!crystal.field_70170_p.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)crystal.field_70170_p, pos)) {
                return false;
            }
            return !crystal.field_70170_p.func_175674_a(crystal, boxCraft.func_72317_d(crystal.field_70165_t, crystal.field_70163_u, crystal.field_70161_v), EntityUtils.selectItemClassInstaceof(ItemRockCrystalBase.class)).isEmpty();
        }

        public static int getCraftMode(@Nonnull Entity crystal, @Nonnull AxisAlignedBB boxCraft) {
            if (!((EntityStarlightReacttant)crystal).isInLiquidStarlight(crystal)) {
                return -1;
            }
            BlockPos pos = new BlockPos(crystal.field_70165_t, crystal.field_70163_u, crystal.field_70161_v);
            List foundEntities = crystal.field_70170_p.func_175674_a(crystal, boxCraft.func_186670_a(pos), entity -> true);
            if (foundEntities.isEmpty()) {
                return 0;
            }
            if (!crystal.field_70170_p.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)crystal.field_70170_p, pos)) {
                return -1;
            }
            return foundEntities.stream().filter(EntityUtils.selectItemStack(stack -> ItemUtils.hasOreName((ItemStack)stack, (String)OreDictAlias.ITEM_GLOWSTONE_DUST))).count() == 1L ? 1 : -1;
        }

        public static boolean isInLiquidStarlight(@Nonnull Entity crystal) {
            IBlockState state;
            BlockPos pos = new BlockPos(crystal.field_70165_t, crystal.field_70163_u, crystal.field_70161_v);
            Chunk chunk = crystal.field_70170_p.func_175726_f(pos);
            FluidState fluidState = FluidloggedUtils.getFluidState(chunk, pos, state = chunk.func_177435_g(pos));
            return fluidState.getBlock() instanceof FluidBlockLiquidStarlight && fluidState.isSource() && (state.isSideSolid((IBlockAccess)chunk.func_177412_p(), pos, EnumFacing.DOWN) || chunk.func_177435_g(pos.func_177977_b()).isSideSolid((IBlockAccess)chunk.func_177412_p(), pos.func_177977_b(), EnumFacing.UP));
        }
    }
}

