/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.cb_multipart;

import codechicken.multipart.BlockMultipart$;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.minecraft.McMetaPart;
import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginCBMultipart
implements IASMPlugin {
    @Override
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals("place");
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (this.checkMethod(insn, "retrace")) {
            ((MethodInsnNode)insn).desc = "(Lnet/minecraft/entity/player/EntityPlayer;Z)Lnet/minecraft/util/math/RayTraceResult;";
            instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(3));
            return true;
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        if ("codechicken/multipart/BlockMultipart".equals(classNode.name)) {
            classNode.interfaces.add("git/jbredwards/fluidlogged_api/api/block/IFluidloggable");
            this.addMethod(classNode, "isFluidloggable", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lgit/jbredwards/fluidlogged_api/api/util/FluidState;)Z", "isFluidloggable", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lgit/jbredwards/fluidlogged_api/api/util/FluidState;)Z", generator -> {
                generator.visitVarInsn(25, 1);
                generator.visitVarInsn(25, 2);
                generator.visitVarInsn(25, 3);
                generator.visitVarInsn(25, 4);
            });
            classNode.methods.removeIf(method -> method.name.equals("isAir"));
            return false;
        }
        return true;
    }

    public static final class Hooks {
        @Nonnull
        public static final Map<ResourceLocation, BiPredicate<TMultiPart, FluidState>> PART_CONFIG = new HashMap<ResourceLocation, BiPredicate<TMultiPart, FluidState>>();

        public static boolean isFluidloggable(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull FluidState fluidState) {
            TileMultipart multipart = BlockMultipart$.MODULE$.getTile(world, pos);
            if (multipart != null && !multipart.partList().isEmpty()) {
                for (TMultiPart part : multipart.jPartList()) {
                    BiPredicate<TMultiPart, FluidState> predicate = PART_CONFIG.get(part.getType());
                    if (predicate != null) {
                        return predicate.test(part, fluidState);
                    }
                    if (!(!(part instanceof McMetaPart) ? !FluidloggedAPIConfig.allowDefaults : !FluidloggedUtils.isStateFluidloggable(((McMetaPart)part).state, world, pos, fluidState))) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

