/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.mekanism;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.TileEntityElectricPump;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginMekanismPump
implements IASMPlugin {
    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("suck"), "suck", "(Lmekanism/common/tile/TileEntityElectricPump;Z)Z", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(21, 1);
        });
        return false;
    }

    public static final class Hooks {
        public static boolean suck(@Nonnull TileEntityElectricPump pump, boolean notSimulated) {
            HashSet<Coord4D> checked = new HashSet<Coord4D>(Math.max((int)((float)pump.recurringNodes.size() / 0.75f) + 1, 16));
            Coord4D coord = Coord4D.get((TileEntity)pump);
            if (Hooks.suck(pump, notSimulated, coord, false, checked)) {
                return true;
            }
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if (!Hooks.suck(pump, notSimulated, coord.offset(side), true, checked)) continue;
                return true;
            }
            Coord4D[] shuffledCopy = pump.recurringNodes.toArray(new Coord4D[0]);
            Collections.shuffle(Arrays.asList(shuffledCopy));
            for (Coord4D origin : shuffledCopy) {
                if (Hooks.suck(pump, notSimulated, origin, false, checked)) {
                    return true;
                }
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    Coord4D offset = origin.offset(side);
                    if (coord.distanceTo(offset) > MekanismConfig.current().general.maxPumpRange.val() || !Hooks.suck(pump, notSimulated, offset, true, checked)) continue;
                    return true;
                }
                pump.recurringNodes.remove(origin);
            }
            return false;
        }

        public static boolean suck(@Nonnull TileEntityElectricPump pump, boolean notSimulated, @Nonnull Coord4D coord, boolean cache, @Nonnull Set<Coord4D> checked) {
            if (checked.contains(coord)) {
                return false;
            }
            checked.add(coord);
            FluidStack fluid = MekanismUtils.getFluid((World)pump.func_145831_w(), (Coord4D)coord, (boolean)pump.hasFilter());
            if (fluid != null && (pump.activeType == null || pump.activeType == fluid.getFluid())) {
                if (notSimulated) {
                    BlockStaticLiquid fluidBlock;
                    pump.activeType = fluid.getFluid();
                    pump.fluidTank.fill(fluid, true);
                    if (cache) {
                        pump.recurringNodes.add(coord);
                    }
                    Object object = fluidBlock = fluid.getFluid().canBePlacedInWorld() ? fluid.getFluid().getBlock() : Blocks.field_150355_j;
                    if (MekanismConfig.current().general.pumpWaterSources.val() || !FluidloggedUtils.canCreateSource(fluidBlock.func_176223_P(), pump.func_145831_w(), coord.getPos())) {
                        ((IFluidBlock)fluidBlock).drain(pump.func_145831_w(), coord.getPos(), true);
                    }
                }
                return true;
            }
            return false;
        }
    }
}

