/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.projecte;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginProjectEProjectile
implements IASMPlugin {
    private final boolean isWater;

    public PluginProjectEProjectile(boolean isWaterIn) {
        this.isWater = isWaterIn;
    }

    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (method.name.equals(obfuscated ? "func_70071_h_" : "onUpdate")) {
            return 1;
        }
        return method.name.equals("apply") ? 2 : 0;
    }

    @Override
    public boolean transform(@Nonnull ClassNode classNode, @Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1) {
            if (this.isWater) {
                if (this.checkMethod(insn, "checkReplaceBlock")) {
                    instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(182, classNode.name, obfuscated ? "func_130014_f_" : "getEntityWorld", "()Lnet/minecraft/world/World;", false));
                    instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("mixFluid", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;)Z"));
                    instructions.remove(insn);
                } else if (this.checkMethod(insn, obfuscated ? "func_184185_a" : "playSound")) {
                    instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("doNothing", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/SoundEvent;FF)V"));
                    instructions.remove(insn);
                    return true;
                }
            } else if (this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "getFluidOrReal", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;"));
                instructions.remove(insn);
            } else if (this.checkMethod(insn, "hasBreakPermission")) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(182, classNode.name, obfuscated ? "func_130014_f_" : "getEntityWorld", "()Lnet/minecraft/world/World;", false));
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("vaporizeWater", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/World;)Z"));
                instructions.remove(insn);
                return true;
            }
        } else if (index == 2) {
            if (this.isWater && this.checkMethod(insn, obfuscated ? "func_175623_d" : "isAirBlock")) {
                instructions.insert(insn, (AbstractInsnNode)this.genMethodNode("alwaysTrue", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Z"));
                instructions.remove(insn);
            } else if (this.checkMethod(insn, "checkedPlaceBlock")) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(182, classNode.name, obfuscated ? "func_130014_f_" : "getEntityWorld", "()Lnet/minecraft/world/World;", false));
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("checkPlacedFluid", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;)Z"));
                instructions.remove(insn);
                return true;
            }
        }
        return false;
    }

    public static final class Hooks {
        public static boolean alwaysTrue(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            return true;
        }

        public static boolean checkPlacedFluid(@Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState fluid, @Nonnull World world) {
            if (world.func_73046_m() != null && world.func_73046_m().func_175579_a(world, pos, player)) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
                FluidStack fluidStack;
                if (world.field_73011_w.func_177500_n() && (fluidStack = FluidState.of(fluid).createFluidStack()).getFluid().doesVaporize(fluidStack)) {
                    FluidloggedUtils.playVaporizeEffects(world, pos, fluidStack);
                    return true;
                }
                return world.func_175656_a(pos, fluid);
            }
            FluidState fluidState = FluidState.of(fluid);
            return FluidloggedUtils.isStateFluidloggable(state, (IBlockAccess)world, pos, fluidState) && FluidloggedUtils.setFluidState(world, pos, state, fluidState, true);
        }

        public static void doNothing(@Nonnull Entity entity, @Nonnull SoundEvent soundIn, float volume, float pitch) {
        }

        public static boolean mixFluid(@Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState toPlace, @Nonnull World world) {
            if (world.func_73046_m() != null && !world.func_73046_m().func_175579_a(world, pos, player) && world.func_175656_a(pos, toPlace)) {
                Blocks.field_150353_l.func_180688_d(world, pos);
                return true;
            }
            return false;
        }

        public static boolean vaporizeWater(@Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull World world) {
            if (world.func_73046_m() != null && !world.func_73046_m().func_175579_a(world, pos, player) && FluidloggedUtils.setFluidToAir(world, pos, null, 3)) {
                FluidRegistry.WATER.vaporize(null, world, pos, new FluidStack(FluidRegistry.WATER, 1000));
            }
            return false;
        }
    }
}

